<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelDateTimeType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Date and time of trip, that allows specifying a time window before and after the given date.
 * @subpackage Structs
 */
class TravelDateTimeType extends AbstractStructBase
{
    /**
     * The DepartureDateTime
     * Meta informations extracted from the WSDL
     * - documentation: This date should be of the form YYYY-MM-DDTHH:MM:SS | IntelliSell Date Time type
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * Meta informations extracted from the WSDL
     * - documentation: This date should be of the form YYYY-MM-DDTHH:MM:SS | IntelliSell Date Time type
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The DepartureDates
     * @var \Sabre\BargainFinderMax\Structs\DepartureDates
     */
    public $DepartureDates;
    /**
     * The ArrivalDates
     * @var \Sabre\BargainFinderMax\Structs\ArrivalDates
     */
    public $ArrivalDates;
    /**
     * The DepartureWindow
     * Meta informations extracted from the WSDL
     * - documentation: This should be of the form HHMMHHMM. | IntelliSell Time Window type in format HHMMHHMM.
     * - minOccurs: 0
     * - pattern: ([0-2][0-9][0-5][0-9]){2}
     * @var string
     */
    public $DepartureWindow;
    /**
     * The ArrivalWindow
     * Meta informations extracted from the WSDL
     * - documentation: This should be of the form HHMMHHMM. | IntelliSell Time Window type in format HHMMHHMM.
     * - minOccurs: 0
     * - pattern: ([0-2][0-9][0-5][0-9]){2}
     * @var string
     */
    public $ArrivalWindow;
    /**
     * Constructor method for TravelDateTimeType
     * @uses TravelDateTimeType::setDepartureDateTime()
     * @uses TravelDateTimeType::setArrivalDateTime()
     * @uses TravelDateTimeType::setDepartureDates()
     * @uses TravelDateTimeType::setArrivalDates()
     * @uses TravelDateTimeType::setDepartureWindow()
     * @uses TravelDateTimeType::setArrivalWindow()
     * @param string $departureDateTime
     * @param string $arrivalDateTime
     * @param \Sabre\BargainFinderMax\Structs\DepartureDates $departureDates
     * @param \Sabre\BargainFinderMax\Structs\ArrivalDates $arrivalDates
     * @param string $departureWindow
     * @param string $arrivalWindow
     */
    public function __construct($departureDateTime = null, $arrivalDateTime = null, \Sabre\BargainFinderMax\Structs\DepartureDates $departureDates = null, \Sabre\BargainFinderMax\Structs\ArrivalDates $arrivalDates = null, $departureWindow = null, $arrivalWindow = null)
    {
        $this
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setDepartureDates($departureDates)
            ->setArrivalDates($arrivalDates)
            ->setDepartureWindow($departureWindow)
            ->setArrivalWindow($arrivalWindow);
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \Sabre\BargainFinderMax\Structs\TravelDateTimeType
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \Sabre\BargainFinderMax\Structs\TravelDateTimeType
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get DepartureDates value
     * @return \Sabre\BargainFinderMax\Structs\DepartureDates|null
     */
    public function getDepartureDates()
    {
        return $this->DepartureDates;
    }
    /**
     * Set DepartureDates value
     * @param \Sabre\BargainFinderMax\Structs\DepartureDates $departureDates
     * @return \Sabre\BargainFinderMax\Structs\TravelDateTimeType
     */
    public function setDepartureDates(\Sabre\BargainFinderMax\Structs\DepartureDates $departureDates = null)
    {
        $this->DepartureDates = $departureDates;
        return $this;
    }
    /**
     * Get ArrivalDates value
     * @return \Sabre\BargainFinderMax\Structs\ArrivalDates|null
     */
    public function getArrivalDates()
    {
        return $this->ArrivalDates;
    }
    /**
     * Set ArrivalDates value
     * @param \Sabre\BargainFinderMax\Structs\ArrivalDates $arrivalDates
     * @return \Sabre\BargainFinderMax\Structs\TravelDateTimeType
     */
    public function setArrivalDates(\Sabre\BargainFinderMax\Structs\ArrivalDates $arrivalDates = null)
    {
        $this->ArrivalDates = $arrivalDates;
        return $this;
    }
    /**
     * Get DepartureWindow value
     * @return string|null
     */
    public function getDepartureWindow()
    {
        return $this->DepartureWindow;
    }
    /**
     * Set DepartureWindow value
     * @param string $departureWindow
     * @return \Sabre\BargainFinderMax\Structs\TravelDateTimeType
     */
    public function setDepartureWindow($departureWindow = null)
    {
        $this->DepartureWindow = $departureWindow;
        return $this;
    }
    /**
     * Get ArrivalWindow value
     * @return string|null
     */
    public function getArrivalWindow()
    {
        return $this->ArrivalWindow;
    }
    /**
     * Set ArrivalWindow value
     * @param string $arrivalWindow
     * @return \Sabre\BargainFinderMax\Structs\TravelDateTimeType
     */
    public function setArrivalWindow($arrivalWindow = null)
    {
        $this->ArrivalWindow = $arrivalWindow;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TravelDateTimeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
