<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TotalFareType Structs
 * @subpackage Structs
 */
class TotalFareType extends AbstractStructBase
{
    /**
     * The TotalPrice
     * Meta informations extracted from the WSDL
     * - documentation: Total price for all passenger types
     * - use: required
     * @var float
     */
    public $TotalPrice;
    /**
     * The TotalTaxes
     * Meta informations extracted from the WSDL
     * - documentation: Total taxes
     * - use: required
     * @var float
     */
    public $TotalTaxes;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - documentation: Tax currency code | Currency Code type
     * - use: required | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $Currency;
    /**
     * The BaseFareAmount
     * Meta informations extracted from the WSDL
     * - documentation: Base fare amount
     * - use: optional
     * @var float
     */
    public $BaseFareAmount;
    /**
     * The BaseFareCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Base fare currency code | Currency Code type
     * - use: optional | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $BaseFareCurrency;
    /**
     * The ConstructionAmount
     * Meta informations extracted from the WSDL
     * - documentation: Construction total amount
     * - use: optional
     * @var float
     */
    public $ConstructionAmount;
    /**
     * The ConstructionCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Construction currency code | Currency Code type
     * - use: optional | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $ConstructionCurrency;
    /**
     * The EquivalentAmount
     * Meta informations extracted from the WSDL
     * - documentation: Equivalent (including taxes etc.) amount
     * - use: optional
     * @var float
     */
    public $EquivalentAmount;
    /**
     * The EquivalentCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Equivalent currency code | Currency Code type
     * - use: optional | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $EquivalentCurrency;
    /**
     * The AirExtrasAmount
     * Meta informations extracted from the WSDL
     * - documentation: Air Extras total summary amount (currency for AirExtras is in Currency)
     * @var float
     */
    public $AirExtrasAmount;
    /**
     * The TotalPriceWithAirExtras
     * Meta informations extracted from the WSDL
     * - documentation: Total price with Air Extras (currency for TotalPriceWithAirExtras is in Currency)
     * @var float
     */
    public $TotalPriceWithAirExtras;
    /**
     * The ServiceFeeAmount
     * Meta informations extracted from the WSDL
     * - documentation: Service Fee Amount
     * - use: optional
     * @var float
     */
    public $ServiceFeeAmount;
    /**
     * The ServiceFeeTax
     * Meta informations extracted from the WSDL
     * - documentation: Service Fee Tax
     * - use: optional
     * @var float
     */
    public $ServiceFeeTax;
    /**
     * The TotalTTypeOBFee
     * Meta informations extracted from the WSDL
     * - documentation: Total T-type OB Fee for all passenger types
     * - use: optional
     * @var float
     */
    public $TotalTTypeOBFee;
    /**
     * The EffectivePriceDeviation
     * Meta informations extracted from the WSDL
     * - documentation: Effective Price Deviation
     * - use: optional
     * @var float
     */
    public $EffectivePriceDeviation;
    /**
     * Constructor method for TotalFareType
     * @uses TotalFareType::setTotalPrice()
     * @uses TotalFareType::setTotalTaxes()
     * @uses TotalFareType::setCurrency()
     * @uses TotalFareType::setBaseFareAmount()
     * @uses TotalFareType::setBaseFareCurrency()
     * @uses TotalFareType::setConstructionAmount()
     * @uses TotalFareType::setConstructionCurrency()
     * @uses TotalFareType::setEquivalentAmount()
     * @uses TotalFareType::setEquivalentCurrency()
     * @uses TotalFareType::setAirExtrasAmount()
     * @uses TotalFareType::setTotalPriceWithAirExtras()
     * @uses TotalFareType::setServiceFeeAmount()
     * @uses TotalFareType::setServiceFeeTax()
     * @uses TotalFareType::setTotalTTypeOBFee()
     * @uses TotalFareType::setEffectivePriceDeviation()
     * @param float $totalPrice
     * @param float $totalTaxes
     * @param string $currency
     * @param float $baseFareAmount
     * @param string $baseFareCurrency
     * @param float $constructionAmount
     * @param string $constructionCurrency
     * @param float $equivalentAmount
     * @param string $equivalentCurrency
     * @param float $airExtrasAmount
     * @param float $totalPriceWithAirExtras
     * @param float $serviceFeeAmount
     * @param float $serviceFeeTax
     * @param float $totalTTypeOBFee
     * @param float $effectivePriceDeviation
     */
    public function __construct($totalPrice = null, $totalTaxes = null, $currency = null, $baseFareAmount = null, $baseFareCurrency = null, $constructionAmount = null, $constructionCurrency = null, $equivalentAmount = null, $equivalentCurrency = null, $airExtrasAmount = null, $totalPriceWithAirExtras = null, $serviceFeeAmount = null, $serviceFeeTax = null, $totalTTypeOBFee = null, $effectivePriceDeviation = null)
    {
        $this
            ->setTotalPrice($totalPrice)
            ->setTotalTaxes($totalTaxes)
            ->setCurrency($currency)
            ->setBaseFareAmount($baseFareAmount)
            ->setBaseFareCurrency($baseFareCurrency)
            ->setConstructionAmount($constructionAmount)
            ->setConstructionCurrency($constructionCurrency)
            ->setEquivalentAmount($equivalentAmount)
            ->setEquivalentCurrency($equivalentCurrency)
            ->setAirExtrasAmount($airExtrasAmount)
            ->setTotalPriceWithAirExtras($totalPriceWithAirExtras)
            ->setServiceFeeAmount($serviceFeeAmount)
            ->setServiceFeeTax($serviceFeeTax)
            ->setTotalTTypeOBFee($totalTTypeOBFee)
            ->setEffectivePriceDeviation($effectivePriceDeviation);
    }
    /**
     * Get TotalPrice value
     * @return float
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param float $totalPrice
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public function setTotalPrice($totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get TotalTaxes value
     * @return float
     */
    public function getTotalTaxes()
    {
        return $this->TotalTaxes;
    }
    /**
     * Set TotalTaxes value
     * @param float $totalTaxes
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public function setTotalTaxes($totalTaxes = null)
    {
        $this->TotalTaxes = $totalTaxes;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public function setCurrency($currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get BaseFareAmount value
     * @return float|null
     */
    public function getBaseFareAmount()
    {
        return $this->BaseFareAmount;
    }
    /**
     * Set BaseFareAmount value
     * @param float $baseFareAmount
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public function setBaseFareAmount($baseFareAmount = null)
    {
        $this->BaseFareAmount = $baseFareAmount;
        return $this;
    }
    /**
     * Get BaseFareCurrency value
     * @return string|null
     */
    public function getBaseFareCurrency()
    {
        return $this->BaseFareCurrency;
    }
    /**
     * Set BaseFareCurrency value
     * @param string $baseFareCurrency
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public function setBaseFareCurrency($baseFareCurrency = null)
    {
        $this->BaseFareCurrency = $baseFareCurrency;
        return $this;
    }
    /**
     * Get ConstructionAmount value
     * @return float|null
     */
    public function getConstructionAmount()
    {
        return $this->ConstructionAmount;
    }
    /**
     * Set ConstructionAmount value
     * @param float $constructionAmount
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public function setConstructionAmount($constructionAmount = null)
    {
        $this->ConstructionAmount = $constructionAmount;
        return $this;
    }
    /**
     * Get ConstructionCurrency value
     * @return string|null
     */
    public function getConstructionCurrency()
    {
        return $this->ConstructionCurrency;
    }
    /**
     * Set ConstructionCurrency value
     * @param string $constructionCurrency
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public function setConstructionCurrency($constructionCurrency = null)
    {
        $this->ConstructionCurrency = $constructionCurrency;
        return $this;
    }
    /**
     * Get EquivalentAmount value
     * @return float|null
     */
    public function getEquivalentAmount()
    {
        return $this->EquivalentAmount;
    }
    /**
     * Set EquivalentAmount value
     * @param float $equivalentAmount
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public function setEquivalentAmount($equivalentAmount = null)
    {
        $this->EquivalentAmount = $equivalentAmount;
        return $this;
    }
    /**
     * Get EquivalentCurrency value
     * @return string|null
     */
    public function getEquivalentCurrency()
    {
        return $this->EquivalentCurrency;
    }
    /**
     * Set EquivalentCurrency value
     * @param string $equivalentCurrency
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public function setEquivalentCurrency($equivalentCurrency = null)
    {
        $this->EquivalentCurrency = $equivalentCurrency;
        return $this;
    }
    /**
     * Get AirExtrasAmount value
     * @return float|null
     */
    public function getAirExtrasAmount()
    {
        return $this->AirExtrasAmount;
    }
    /**
     * Set AirExtrasAmount value
     * @param float $airExtrasAmount
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public function setAirExtrasAmount($airExtrasAmount = null)
    {
        $this->AirExtrasAmount = $airExtrasAmount;
        return $this;
    }
    /**
     * Get TotalPriceWithAirExtras value
     * @return float|null
     */
    public function getTotalPriceWithAirExtras()
    {
        return $this->TotalPriceWithAirExtras;
    }
    /**
     * Set TotalPriceWithAirExtras value
     * @param float $totalPriceWithAirExtras
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public function setTotalPriceWithAirExtras($totalPriceWithAirExtras = null)
    {
        $this->TotalPriceWithAirExtras = $totalPriceWithAirExtras;
        return $this;
    }
    /**
     * Get ServiceFeeAmount value
     * @return float|null
     */
    public function getServiceFeeAmount()
    {
        return $this->ServiceFeeAmount;
    }
    /**
     * Set ServiceFeeAmount value
     * @param float $serviceFeeAmount
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public function setServiceFeeAmount($serviceFeeAmount = null)
    {
        $this->ServiceFeeAmount = $serviceFeeAmount;
        return $this;
    }
    /**
     * Get ServiceFeeTax value
     * @return float|null
     */
    public function getServiceFeeTax()
    {
        return $this->ServiceFeeTax;
    }
    /**
     * Set ServiceFeeTax value
     * @param float $serviceFeeTax
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public function setServiceFeeTax($serviceFeeTax = null)
    {
        $this->ServiceFeeTax = $serviceFeeTax;
        return $this;
    }
    /**
     * Get TotalTTypeOBFee value
     * @return float|null
     */
    public function getTotalTTypeOBFee()
    {
        return $this->TotalTTypeOBFee;
    }
    /**
     * Set TotalTTypeOBFee value
     * @param float $totalTTypeOBFee
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public function setTotalTTypeOBFee($totalTTypeOBFee = null)
    {
        $this->TotalTTypeOBFee = $totalTTypeOBFee;
        return $this;
    }
    /**
     * Get EffectivePriceDeviation value
     * @return float|null
     */
    public function getEffectivePriceDeviation()
    {
        return $this->EffectivePriceDeviation;
    }
    /**
     * Set EffectivePriceDeviation value
     * @param float $effectivePriceDeviation
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public function setEffectivePriceDeviation($effectivePriceDeviation = null)
    {
        $this->EffectivePriceDeviation = $effectivePriceDeviation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TotalFareType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
