<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeOfDay Structs
 * @subpackage Structs
 */
class TimeOfDay extends AbstractStructBase
{
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxInclusive: 10
     * - minInclusive: 0
     * @var float
     */
    public $Weight;
    /**
     * The Distribution
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Distribution[]
     */
    public $Distribution;
    /**
     * Constructor method for TimeOfDay
     * @uses TimeOfDay::setWeight()
     * @uses TimeOfDay::setDistribution()
     * @param float $weight
     * @param \Sabre\BargainFinderMax\Structs\Distribution[] $distribution
     */
    public function __construct($weight = null, array $distribution = array())
    {
        $this
            ->setWeight($weight)
            ->setDistribution($distribution);
    }
    /**
     * Get Weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \Sabre\BargainFinderMax\Structs\TimeOfDay
     */
    public function setWeight($weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Distribution value
     * @return \Sabre\BargainFinderMax\Structs\Distribution[]|null
     */
    public function getDistribution()
    {
        return $this->Distribution;
    }
    /**
     * Set Distribution value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Distribution[] $distribution
     * @return \Sabre\BargainFinderMax\Structs\TimeOfDay
     */
    public function setDistribution(array $distribution = array())
    {
        $this->Distribution = $distribution;
        return $this;
    }
    /**
     * Add item to Distribution value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Distribution $item
     * @return \Sabre\BargainFinderMax\Structs\TimeOfDay
     */
    public function addToDistribution(\Sabre\BargainFinderMax\Structs\Distribution $item)
    {
        $this->Distribution[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TimeOfDay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
