<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketingInfoRS_Type Structs
 * Meta informations extracted from the WSDL
 * - documentation: Extends TicketingInfoType to provide an eTicketNumber.
 * @subpackage Structs
 */
class TicketingInfoRS_Type extends AbstractStructBase
{
    /**
     * The TicketType
     * Meta informations extracted from the WSDL
     * - documentation: TicketType - Indicates the type of ticket (Paper, eTicket)
     * - use: required
     * @var string
     */
    public $TicketType;
    /**
     * The TicketAdvisory
     * Meta informations extracted from the WSDL
     * - documentation: Open text field available for additional ticket information.
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FreeTextType[]
     */
    public $TicketAdvisory;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - documentation: Place holder for additional elements.
     * - minOccurs: 0
     * @var string
     */
    public $TPA_Extensions;
    /**
     * The eTicketNumber
     * Meta informations extracted from the WSDL
     * - documentation: If reservation is electronically ticketed at time of booking, this is the field for the eTicket number. | Used forAlpha-Numeric Strings, length 1 to 14
     * - use: optional
     * - pattern: [0-9a-zA-Z]{1,14}
     * @var string
     */
    public $eTicketNumber;
    /**
     * The TicketTimeLimit
     * Meta informations extracted from the WSDL
     * - documentation: TicketTimeLimit - Indicates the ticketing arrangement, and allows for the requirement that an itinerary must be ticketed by a certain date and time.
     * - use: optional
     * @var string
     */
    public $TicketTimeLimit;
    /**
     * The ValidInterline
     * Meta informations extracted from the WSDL
     * - default: Unknown
     * - documentation: ValidInterline - Indicates validation of interline ticketing aggrement, possible values (Yes, No, Unknown), default=unknown
     * - use: optional
     * @var string
     */
    public $ValidInterline;
    /**
     * Constructor method for TicketingInfoRS_Type
     * @uses TicketingInfoRS_Type::setTicketType()
     * @uses TicketingInfoRS_Type::setTicketAdvisory()
     * @uses TicketingInfoRS_Type::setTPA_Extensions()
     * @uses TicketingInfoRS_Type::setETicketNumber()
     * @uses TicketingInfoRS_Type::setTicketTimeLimit()
     * @uses TicketingInfoRS_Type::setValidInterline()
     * @param string $ticketType
     * @param \Sabre\BargainFinderMax\Structs\FreeTextType[] $ticketAdvisory
     * @param string $tPA_Extensions
     * @param string $eTicketNumber
     * @param string $ticketTimeLimit
     * @param string $validInterline
     */
    public function __construct($ticketType = null, array $ticketAdvisory = array(), $tPA_Extensions = null, $eTicketNumber = null, $ticketTimeLimit = null, $validInterline = 'Unknown')
    {
        $this
            ->setTicketType($ticketType)
            ->setTicketAdvisory($ticketAdvisory)
            ->setTPA_Extensions($tPA_Extensions)
            ->setETicketNumber($eTicketNumber)
            ->setTicketTimeLimit($ticketTimeLimit)
            ->setValidInterline($validInterline);
    }
    /**
     * Get TicketType value
     * @return string
     */
    public function getTicketType()
    {
        return $this->TicketType;
    }
    /**
     * Set TicketType value
     * @uses \Sabre\BargainFinderMax\Enums\TicketType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\TicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketType
     * @return \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type
     */
    public function setTicketType($ticketType = null)
    {
        $this->TicketType = $ticketType;
        return $this;
    }
    /**
     * Get TicketAdvisory value
     * @return \Sabre\BargainFinderMax\Structs\FreeTextType[]|null
     */
    public function getTicketAdvisory()
    {
        return $this->TicketAdvisory;
    }
    /**
     * Set TicketAdvisory value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FreeTextType[] $ticketAdvisory
     * @return \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type
     */
    public function setTicketAdvisory(array $ticketAdvisory = array())
    {
        $this->TicketAdvisory = $ticketAdvisory;
        return $this;
    }
    /**
     * Add item to TicketAdvisory value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FreeTextType $item
     * @return \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type
     */
    public function addToTicketAdvisory(\Sabre\BargainFinderMax\Structs\FreeTextType $item)
    {
        $this->TicketAdvisory[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return string|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param string $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get eTicketNumber value
     * @return string|null
     */
    public function getETicketNumber()
    {
        return $this->eTicketNumber;
    }
    /**
     * Set eTicketNumber value
     * @param string $eTicketNumber
     * @return \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type
     */
    public function setETicketNumber($eTicketNumber = null)
    {
        $this->eTicketNumber = $eTicketNumber;
        return $this;
    }
    /**
     * Get TicketTimeLimit value
     * @return string|null
     */
    public function getTicketTimeLimit()
    {
        return $this->TicketTimeLimit;
    }
    /**
     * Set TicketTimeLimit value
     * @param string $ticketTimeLimit
     * @return \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type
     */
    public function setTicketTimeLimit($ticketTimeLimit = null)
    {
        $this->TicketTimeLimit = $ticketTimeLimit;
        return $this;
    }
    /**
     * Get ValidInterline value
     * @return string|null
     */
    public function getValidInterline()
    {
        return $this->ValidInterline;
    }
    /**
     * Set ValidInterline value
     * @uses \Sabre\BargainFinderMax\Enums\ValidInterlineType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\ValidInterlineType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $validInterline
     * @return \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type
     */
    public function setValidInterline($validInterline = 'Unknown')
    {
        $this->ValidInterline = $validInterline;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
