<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Taxes Structs
 * Meta informations extracted from the WSDL
 * - documentation: Specify Taxes (/TX) | This is a collection of Taxes | This is a collection of Taxes | This is a collection of Taxes
 * - minOccurs: 0
 * @subpackage Structs
 */
class Taxes extends AbstractStructBase
{
    /**
     * The PassengerIndex
     * Meta informations extracted from the WSDL
     * - documentation: Allows to associate taxes with specific requested passenger
     * - use: required
     * @var int
     */
    public $PassengerIndex;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - documentation: Specify tax amount and code. | Any individual tax applied to the fare | Any individual tax applied to the fare | Any individual tax applied to the fare
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TaxCodeAmountType
     */
    public $Tax;
    /**
     * The IsRefundable
     * Meta informations extracted from the WSDL
     * - documentation: Validates if given tax is refundable or not
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TaxCodeType[]
     */
    public $IsRefundable;
    /**
     * The FareComponentsTaxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FareComponentsTaxes
     */
    public $FareComponentsTaxes;
    /**
     * The LegsTaxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\LegsTaxes
     */
    public $LegsTaxes;
    /**
     * The TaxSummary
     * Meta informations extracted from the WSDL
     * - documentation: Tax Summary Information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AirTaxSummaryType[]
     */
    public $TaxSummary;
    /**
     * The TotalTax
     * Meta informations extracted from the WSDL
     * - documentation: Total (summary) of taxes applied to the fare
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CurrencyAmountType
     */
    public $TotalTax;
    /**
     * Constructor method for Taxes
     * @uses Taxes::setPassengerIndex()
     * @uses Taxes::setTax()
     * @uses Taxes::setIsRefundable()
     * @uses Taxes::setFareComponentsTaxes()
     * @uses Taxes::setLegsTaxes()
     * @uses Taxes::setTaxSummary()
     * @uses Taxes::setTotalTax()
     * @param int $passengerIndex
     * @param \Sabre\BargainFinderMax\Structs\TaxCodeAmountType $tax
     * @param \Sabre\BargainFinderMax\Structs\TaxCodeType[] $isRefundable
     * @param \Sabre\BargainFinderMax\Structs\FareComponentsTaxes $fareComponentsTaxes
     * @param \Sabre\BargainFinderMax\Structs\LegsTaxes $legsTaxes
     * @param \Sabre\BargainFinderMax\Structs\AirTaxSummaryType[] $taxSummary
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $totalTax
     */
    public function __construct($passengerIndex = null, \Sabre\BargainFinderMax\Structs\TaxCodeAmountType $tax = null, array $isRefundable = array(), \Sabre\BargainFinderMax\Structs\FareComponentsTaxes $fareComponentsTaxes = null, \Sabre\BargainFinderMax\Structs\LegsTaxes $legsTaxes = null, array $taxSummary = array(), \Sabre\BargainFinderMax\Structs\CurrencyAmountType $totalTax = null)
    {
        $this
            ->setPassengerIndex($passengerIndex)
            ->setTax($tax)
            ->setIsRefundable($isRefundable)
            ->setFareComponentsTaxes($fareComponentsTaxes)
            ->setLegsTaxes($legsTaxes)
            ->setTaxSummary($taxSummary)
            ->setTotalTax($totalTax);
    }
    /**
     * Get PassengerIndex value
     * @return int
     */
    public function getPassengerIndex()
    {
        return $this->PassengerIndex;
    }
    /**
     * Set PassengerIndex value
     * @param int $passengerIndex
     * @return \Sabre\BargainFinderMax\Structs\Taxes
     */
    public function setPassengerIndex($passengerIndex = null)
    {
        $this->PassengerIndex = $passengerIndex;
        return $this;
    }
    /**
     * Get Tax value
     * @return \Sabre\BargainFinderMax\Structs\TaxCodeAmountType|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param \Sabre\BargainFinderMax\Structs\TaxCodeAmountType $tax
     * @return \Sabre\BargainFinderMax\Structs\Taxes
     */
    public function setTax(\Sabre\BargainFinderMax\Structs\TaxCodeAmountType $tax = null)
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get IsRefundable value
     * @return \Sabre\BargainFinderMax\Structs\TaxCodeType[]|null
     */
    public function getIsRefundable()
    {
        return $this->IsRefundable;
    }
    /**
     * Set IsRefundable value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxCodeType[] $isRefundable
     * @return \Sabre\BargainFinderMax\Structs\Taxes
     */
    public function setIsRefundable(array $isRefundable = array())
    {
        $this->IsRefundable = $isRefundable;
        return $this;
    }
    /**
     * Add item to IsRefundable value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxCodeType $item
     * @return \Sabre\BargainFinderMax\Structs\Taxes
     */
    public function addToIsRefundable(\Sabre\BargainFinderMax\Structs\TaxCodeType $item)
    {
        $this->IsRefundable[] = $item;
        return $this;
    }
    /**
     * Get FareComponentsTaxes value
     * @return \Sabre\BargainFinderMax\Structs\FareComponentsTaxes|null
     */
    public function getFareComponentsTaxes()
    {
        return $this->FareComponentsTaxes;
    }
    /**
     * Set FareComponentsTaxes value
     * @param \Sabre\BargainFinderMax\Structs\FareComponentsTaxes $fareComponentsTaxes
     * @return \Sabre\BargainFinderMax\Structs\Taxes
     */
    public function setFareComponentsTaxes(\Sabre\BargainFinderMax\Structs\FareComponentsTaxes $fareComponentsTaxes = null)
    {
        $this->FareComponentsTaxes = $fareComponentsTaxes;
        return $this;
    }
    /**
     * Get LegsTaxes value
     * @return \Sabre\BargainFinderMax\Structs\LegsTaxes|null
     */
    public function getLegsTaxes()
    {
        return $this->LegsTaxes;
    }
    /**
     * Set LegsTaxes value
     * @param \Sabre\BargainFinderMax\Structs\LegsTaxes $legsTaxes
     * @return \Sabre\BargainFinderMax\Structs\Taxes
     */
    public function setLegsTaxes(\Sabre\BargainFinderMax\Structs\LegsTaxes $legsTaxes = null)
    {
        $this->LegsTaxes = $legsTaxes;
        return $this;
    }
    /**
     * Get TaxSummary value
     * @return \Sabre\BargainFinderMax\Structs\AirTaxSummaryType[]|null
     */
    public function getTaxSummary()
    {
        return $this->TaxSummary;
    }
    /**
     * Set TaxSummary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirTaxSummaryType[] $taxSummary
     * @return \Sabre\BargainFinderMax\Structs\Taxes
     */
    public function setTaxSummary(array $taxSummary = array())
    {
        $this->TaxSummary = $taxSummary;
        return $this;
    }
    /**
     * Add item to TaxSummary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirTaxSummaryType $item
     * @return \Sabre\BargainFinderMax\Structs\Taxes
     */
    public function addToTaxSummary(\Sabre\BargainFinderMax\Structs\AirTaxSummaryType $item)
    {
        $this->TaxSummary[] = $item;
        return $this;
    }
    /**
     * Get TotalTax value
     * @return \Sabre\BargainFinderMax\Structs\CurrencyAmountType|null
     */
    public function getTotalTax()
    {
        return $this->TotalTax;
    }
    /**
     * Set TotalTax value
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $totalTax
     * @return \Sabre\BargainFinderMax\Structs\Taxes
     */
    public function setTotalTax(\Sabre\BargainFinderMax\Structs\CurrencyAmountType $totalTax = null)
    {
        $this->TotalTax = $totalTax;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Taxes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
