<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxRestrictionsType Structs
 * @subpackage Structs
 */
class TaxRestrictionsType extends AbstractStructBase
{
    /**
     * The MinAmount
     * Meta informations extracted from the WSDL
     * - documentation: Min Tax Amount
     * - use: optional
     * @var float
     */
    public $MinAmount;
    /**
     * The MaxAmount
     * Meta informations extracted from the WSDL
     * - documentation: Max Tax Amount
     * - use: optional
     * @var float
     */
    public $MaxAmount;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - documentation: Min Max Tax Currency | Currency Code type
     * - use: optional | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $Currency;
    /**
     * The Rate
     * Meta informations extracted from the WSDL
     * - documentation: Tax Rate Used
     * - use: optional
     * @var float
     */
    public $Rate;
    /**
     * Constructor method for TaxRestrictionsType
     * @uses TaxRestrictionsType::setMinAmount()
     * @uses TaxRestrictionsType::setMaxAmount()
     * @uses TaxRestrictionsType::setCurrency()
     * @uses TaxRestrictionsType::setRate()
     * @param float $minAmount
     * @param float $maxAmount
     * @param string $currency
     * @param float $rate
     */
    public function __construct($minAmount = null, $maxAmount = null, $currency = null, $rate = null)
    {
        $this
            ->setMinAmount($minAmount)
            ->setMaxAmount($maxAmount)
            ->setCurrency($currency)
            ->setRate($rate);
    }
    /**
     * Get MinAmount value
     * @return float|null
     */
    public function getMinAmount()
    {
        return $this->MinAmount;
    }
    /**
     * Set MinAmount value
     * @param float $minAmount
     * @return \Sabre\BargainFinderMax\Structs\TaxRestrictionsType
     */
    public function setMinAmount($minAmount = null)
    {
        $this->MinAmount = $minAmount;
        return $this;
    }
    /**
     * Get MaxAmount value
     * @return float|null
     */
    public function getMaxAmount()
    {
        return $this->MaxAmount;
    }
    /**
     * Set MaxAmount value
     * @param float $maxAmount
     * @return \Sabre\BargainFinderMax\Structs\TaxRestrictionsType
     */
    public function setMaxAmount($maxAmount = null)
    {
        $this->MaxAmount = $maxAmount;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Sabre\BargainFinderMax\Structs\TaxRestrictionsType
     */
    public function setCurrency($currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \Sabre\BargainFinderMax\Structs\TaxRestrictionsType
     */
    public function setRate($rate = null)
    {
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TaxRestrictionsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
