<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxReissueType Structs
 * @subpackage Structs
 */
class TaxReissueType extends AbstractStructBase
{
    /**
     * The RestrictionApply
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Reissue Restriction Apply
     * - use: optional
     * @var bool
     */
    public $RestrictionApply;
    /**
     * The Refundable
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Reissue TAX Refundable
     * - use: optional
     * @var bool
     */
    public $Refundable;
    /**
     * The MaxAmount
     * Meta informations extracted from the WSDL
     * - documentation: Reissue Tax Max Amount
     * - use: optional
     * @var float
     */
    public $MaxAmount;
    /**
     * The MaxCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Reissue Tax Max Amount Currency | Currency Code type
     * - use: optional | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $MaxCurrency;
    /**
     * The TaxType
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TaxType;
    /**
     * Constructor method for TaxReissueType
     * @uses TaxReissueType::setRestrictionApply()
     * @uses TaxReissueType::setRefundable()
     * @uses TaxReissueType::setMaxAmount()
     * @uses TaxReissueType::setMaxCurrency()
     * @uses TaxReissueType::setTaxType()
     * @param bool $restrictionApply
     * @param bool $refundable
     * @param float $maxAmount
     * @param string $maxCurrency
     * @param string $taxType
     */
    public function __construct($restrictionApply = false, $refundable = false, $maxAmount = null, $maxCurrency = null, $taxType = null)
    {
        $this
            ->setRestrictionApply($restrictionApply)
            ->setRefundable($refundable)
            ->setMaxAmount($maxAmount)
            ->setMaxCurrency($maxCurrency)
            ->setTaxType($taxType);
    }
    /**
     * Get RestrictionApply value
     * @return bool|null
     */
    public function getRestrictionApply()
    {
        return $this->RestrictionApply;
    }
    /**
     * Set RestrictionApply value
     * @param bool $restrictionApply
     * @return \Sabre\BargainFinderMax\Structs\TaxReissueType
     */
    public function setRestrictionApply($restrictionApply = false)
    {
        $this->RestrictionApply = $restrictionApply;
        return $this;
    }
    /**
     * Get Refundable value
     * @return bool|null
     */
    public function getRefundable()
    {
        return $this->Refundable;
    }
    /**
     * Set Refundable value
     * @param bool $refundable
     * @return \Sabre\BargainFinderMax\Structs\TaxReissueType
     */
    public function setRefundable($refundable = false)
    {
        $this->Refundable = $refundable;
        return $this;
    }
    /**
     * Get MaxAmount value
     * @return float|null
     */
    public function getMaxAmount()
    {
        return $this->MaxAmount;
    }
    /**
     * Set MaxAmount value
     * @param float $maxAmount
     * @return \Sabre\BargainFinderMax\Structs\TaxReissueType
     */
    public function setMaxAmount($maxAmount = null)
    {
        $this->MaxAmount = $maxAmount;
        return $this;
    }
    /**
     * Get MaxCurrency value
     * @return string|null
     */
    public function getMaxCurrency()
    {
        return $this->MaxCurrency;
    }
    /**
     * Set MaxCurrency value
     * @param string $maxCurrency
     * @return \Sabre\BargainFinderMax\Structs\TaxReissueType
     */
    public function setMaxCurrency($maxCurrency = null)
    {
        $this->MaxCurrency = $maxCurrency;
        return $this;
    }
    /**
     * Get TaxType value
     * @return string|null
     */
    public function getTaxType()
    {
        return $this->TaxType;
    }
    /**
     * Set TaxType value
     * @param string $taxType
     * @return \Sabre\BargainFinderMax\Structs\TaxReissueType
     */
    public function setTaxType($taxType = null)
    {
        $this->TaxType = $taxType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TaxReissueType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
