<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SurfaceType Structs
 * @subpackage Structs
 */
class SurfaceType extends AbstractStructBase
{
    /**
     * The Unchargeable
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Unchargeable
     * @var bool
     */
    public $Unchargeable;
    /**
     * The Stopover
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Stopover segment
     * - use: optional
     * @var bool
     */
    public $Stopover;
    /**
     * The ExtraMileageAllowance
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Extra mileage allowance
     * - use: optional
     * @var bool
     */
    public $ExtraMileageAllowance;
    /**
     * The StopoverCharge
     * Meta informations extracted from the WSDL
     * - documentation: City specific stopover charge amount
     * - use: optional
     * @var float
     */
    public $StopoverCharge;
    /**
     * The StopoverChargeCurrency
     * Meta informations extracted from the WSDL
     * - documentation: City specific stopover charge currency | Currency Code type
     * - use: optional | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $StopoverChargeCurrency;
    /**
     * Constructor method for SurfaceType
     * @uses SurfaceType::setUnchargeable()
     * @uses SurfaceType::setStopover()
     * @uses SurfaceType::setExtraMileageAllowance()
     * @uses SurfaceType::setStopoverCharge()
     * @uses SurfaceType::setStopoverChargeCurrency()
     * @param bool $unchargeable
     * @param bool $stopover
     * @param bool $extraMileageAllowance
     * @param float $stopoverCharge
     * @param string $stopoverChargeCurrency
     */
    public function __construct($unchargeable = false, $stopover = false, $extraMileageAllowance = false, $stopoverCharge = null, $stopoverChargeCurrency = null)
    {
        $this
            ->setUnchargeable($unchargeable)
            ->setStopover($stopover)
            ->setExtraMileageAllowance($extraMileageAllowance)
            ->setStopoverCharge($stopoverCharge)
            ->setStopoverChargeCurrency($stopoverChargeCurrency);
    }
    /**
     * Get Unchargeable value
     * @return bool|null
     */
    public function getUnchargeable()
    {
        return $this->Unchargeable;
    }
    /**
     * Set Unchargeable value
     * @param bool $unchargeable
     * @return \Sabre\BargainFinderMax\Structs\SurfaceType
     */
    public function setUnchargeable($unchargeable = false)
    {
        $this->Unchargeable = $unchargeable;
        return $this;
    }
    /**
     * Get Stopover value
     * @return bool|null
     */
    public function getStopover()
    {
        return $this->Stopover;
    }
    /**
     * Set Stopover value
     * @param bool $stopover
     * @return \Sabre\BargainFinderMax\Structs\SurfaceType
     */
    public function setStopover($stopover = false)
    {
        $this->Stopover = $stopover;
        return $this;
    }
    /**
     * Get ExtraMileageAllowance value
     * @return bool|null
     */
    public function getExtraMileageAllowance()
    {
        return $this->ExtraMileageAllowance;
    }
    /**
     * Set ExtraMileageAllowance value
     * @param bool $extraMileageAllowance
     * @return \Sabre\BargainFinderMax\Structs\SurfaceType
     */
    public function setExtraMileageAllowance($extraMileageAllowance = false)
    {
        $this->ExtraMileageAllowance = $extraMileageAllowance;
        return $this;
    }
    /**
     * Get StopoverCharge value
     * @return float|null
     */
    public function getStopoverCharge()
    {
        return $this->StopoverCharge;
    }
    /**
     * Set StopoverCharge value
     * @param float $stopoverCharge
     * @return \Sabre\BargainFinderMax\Structs\SurfaceType
     */
    public function setStopoverCharge($stopoverCharge = null)
    {
        $this->StopoverCharge = $stopoverCharge;
        return $this;
    }
    /**
     * Get StopoverChargeCurrency value
     * @return string|null
     */
    public function getStopoverChargeCurrency()
    {
        return $this->StopoverChargeCurrency;
    }
    /**
     * Set StopoverChargeCurrency value
     * @param string $stopoverChargeCurrency
     * @return \Sabre\BargainFinderMax\Structs\SurfaceType
     */
    public function setStopoverChargeCurrency($stopoverChargeCurrency = null)
    {
        $this->StopoverChargeCurrency = $stopoverChargeCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\SurfaceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
