<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SurchargeType Structs
 * @subpackage Structs
 */
class SurchargeType extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: Type
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Surcharge amount | Amount | Used for amounts, max 3 decimals
     * - use: required
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - documentation: Surcharge currency code | Currency | Used for Currency Codes | Used for Currency Codes | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - use: optional
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $Currency;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Surcharge description
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * Constructor method for SurchargeType
     * @uses SurchargeType::setType()
     * @uses SurchargeType::setAmount()
     * @uses SurchargeType::setCurrency()
     * @uses SurchargeType::setDescription()
     * @param string $type
     * @param float $amount
     * @param string $currency
     * @param string $description
     */
    public function __construct($type = null, $amount = null, $currency = null, $description = null)
    {
        $this
            ->setType($type)
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setDescription($description);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\BargainFinderMax\Structs\SurchargeType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\BargainFinderMax\Structs\SurchargeType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Sabre\BargainFinderMax\Structs\SurchargeType
     */
    public function setCurrency($currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Sabre\BargainFinderMax\Structs\SurchargeType
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\SurchargeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
