<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceFee Structs
 * @subpackage Structs
 */
class ServiceFee extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Service Fee Amount | Used for amounts, max 3 decimals
     * - use: required
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The TaxAmount
     * Meta informations extracted from the WSDL
     * - documentation: Service Fee Tax | Used for amounts, max 3 decimals
     * - use: required
     * - fractionDigits: 3
     * @var float
     */
    public $TaxAmount;
    /**
     * Constructor method for ServiceFee
     * @uses ServiceFee::setAmount()
     * @uses ServiceFee::setTaxAmount()
     * @param float $amount
     * @param float $taxAmount
     */
    public function __construct($amount = null, $taxAmount = null)
    {
        $this
            ->setAmount($amount)
            ->setTaxAmount($taxAmount);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\BargainFinderMax\Structs\ServiceFee
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \Sabre\BargainFinderMax\Structs\ServiceFee
     */
    public function setTaxAmount($taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ServiceFee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
