<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScheduleType Structs
 * @subpackage Structs
 */
class ScheduleType extends AbstractStructBase
{
    /**
     * The Ref
     * Meta informations extracted from the WSDL
     * - documentation: Reference to ScheduleDescription ID
     * - use: required
     * @var int
     */
    public $Ref;
    /**
     * The DepartureDateAdjustment
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Departure Date Adjustment(this is the difference in days between leg departure and departure date of this segment leg)
     * @var int
     */
    public $DepartureDateAdjustment;
    /**
     * Constructor method for ScheduleType
     * @uses ScheduleType::setRef()
     * @uses ScheduleType::setDepartureDateAdjustment()
     * @param int $ref
     * @param int $departureDateAdjustment
     */
    public function __construct($ref = null, $departureDateAdjustment = 0)
    {
        $this
            ->setRef($ref)
            ->setDepartureDateAdjustment($departureDateAdjustment);
    }
    /**
     * Get Ref value
     * @return int
     */
    public function getRef()
    {
        return $this->Ref;
    }
    /**
     * Set Ref value
     * @param int $ref
     * @return \Sabre\BargainFinderMax\Structs\ScheduleType
     */
    public function setRef($ref = null)
    {
        $this->Ref = $ref;
        return $this;
    }
    /**
     * Get DepartureDateAdjustment value
     * @return int|null
     */
    public function getDepartureDateAdjustment()
    {
        return $this->DepartureDateAdjustment;
    }
    /**
     * Set DepartureDateAdjustment value
     * @param int $departureDateAdjustment
     * @return \Sabre\BargainFinderMax\Structs\ScheduleType
     */
    public function setDepartureDateAdjustment($departureDateAdjustment = 0)
    {
        $this->DepartureDateAdjustment = $departureDateAdjustment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ScheduleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
