<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScheduleMessageType Structs
 * @subpackage Structs
 */
class ScheduleMessageType extends AbstractStructBase
{
    /**
     * The PricingSource
     * Meta informations extracted from the WSDL
     * - documentation: Pricing Source | Pricing Source name, e.g.: "ADVJR1". One ItineraryGroup can contain information from more than one pricing source, e.g from two JRs.
     * - use: required
     * @var string
     */
    public $PricingSource;
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - documentation: Origin | Airport code type
     * - use: required | optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * - type: UpperCaseAlphaNumericLength3to5
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - documentation: Destination | Airport code type
     * - use: required | optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * - type: UpperCaseAlphaNumericLength3to5
     * @var string
     */
    public $Destination;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: Message type
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: Message
     * @var string
     */
    public $Text;
    /**
     * Constructor method for ScheduleMessageType
     * @uses ScheduleMessageType::setPricingSource()
     * @uses ScheduleMessageType::setOrigin()
     * @uses ScheduleMessageType::setDestination()
     * @uses ScheduleMessageType::setType()
     * @uses ScheduleMessageType::setText()
     * @param string $pricingSource
     * @param string $origin
     * @param string $destination
     * @param string $type
     * @param string $text
     */
    public function __construct($pricingSource = null, $origin = null, $destination = null, $type = null, $text = null)
    {
        $this
            ->setPricingSource($pricingSource)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setType($type)
            ->setText($text);
    }
    /**
     * Get PricingSource value
     * @return string
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @param string $pricingSource
     * @return \Sabre\BargainFinderMax\Structs\ScheduleMessageType
     */
    public function setPricingSource($pricingSource = null)
    {
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \Sabre\BargainFinderMax\Structs\ScheduleMessageType
     */
    public function setOrigin($origin = null)
    {
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \Sabre\BargainFinderMax\Structs\ScheduleMessageType
     */
    public function setDestination($destination = null)
    {
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\BargainFinderMax\Structs\ScheduleMessageType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\BargainFinderMax\Structs\ScheduleMessageType
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ScheduleMessageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
