<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SabreAth Structs
 * Meta informations extracted from the WSDL
 * - documentation: Sabre authentication ID (ATH) - passed into the request to keep session information when communicating with TPF. The use of this element had been deprecated and is achieved by session pooling mechanism in Intellisell.
 * @subpackage Structs
 */
class SabreAth extends AbstractStructBase
{
    /**
     * The Value
     * @var string
     */
    public $Value;
    /**
     * The BinarySecToken
     * @var string
     */
    public $BinarySecToken;
    /**
     * The ConversationID
     * @var string
     */
    public $ConversationID;
    /**
     * Constructor method for SabreAth
     * @uses SabreAth::setValue()
     * @uses SabreAth::setBinarySecToken()
     * @uses SabreAth::setConversationID()
     * @param string $value
     * @param string $binarySecToken
     * @param string $conversationID
     */
    public function __construct($value = null, $binarySecToken = null, $conversationID = null)
    {
        $this
            ->setValue($value)
            ->setBinarySecToken($binarySecToken)
            ->setConversationID($conversationID);
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \Sabre\BargainFinderMax\Structs\SabreAth
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get BinarySecToken value
     * @return string|null
     */
    public function getBinarySecToken()
    {
        return $this->BinarySecToken;
    }
    /**
     * Set BinarySecToken value
     * @param string $binarySecToken
     * @return \Sabre\BargainFinderMax\Structs\SabreAth
     */
    public function setBinarySecToken($binarySecToken = null)
    {
        $this->BinarySecToken = $binarySecToken;
        return $this;
    }
    /**
     * Get ConversationID value
     * @return string|null
     */
    public function getConversationID()
    {
        return $this->ConversationID;
    }
    /**
     * Set ConversationID value
     * @param string $conversationID
     * @return \Sabre\BargainFinderMax\Structs\SabreAth
     */
    public function setConversationID($conversationID = null)
    {
        $this->ConversationID = $conversationID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\SabreAth
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
