<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetailerRulesType Structs
 * @subpackage Structs
 */
class RetailerRulesType extends AbstractStructBase
{
    /**
     * The RetailerRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 1
     * @var \Sabre\BargainFinderMax\Structs\RetailerRule[]
     */
    public $RetailerRule;
    /**
     * The Force
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: If set to true, only fares with a matched Business Rule containing the specified Retailer Rule Qualifier will be returned
     * - use: optional
     * @var bool
     */
    public $Force;
    /**
     * Constructor method for RetailerRulesType
     * @uses RetailerRulesType::setRetailerRule()
     * @uses RetailerRulesType::setForce()
     * @param \Sabre\BargainFinderMax\Structs\RetailerRule[] $retailerRule
     * @param bool $force
     */
    public function __construct(array $retailerRule = array(), $force = false)
    {
        $this
            ->setRetailerRule($retailerRule)
            ->setForce($force);
    }
    /**
     * Get RetailerRule value
     * @return \Sabre\BargainFinderMax\Structs\RetailerRule[]
     */
    public function getRetailerRule()
    {
        return $this->RetailerRule;
    }
    /**
     * Set RetailerRule value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\RetailerRule[] $retailerRule
     * @return \Sabre\BargainFinderMax\Structs\RetailerRulesType
     */
    public function setRetailerRule(array $retailerRule = array())
    {
        $this->RetailerRule = $retailerRule;
        return $this;
    }
    /**
     * Add item to RetailerRule value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\RetailerRule $item
     * @return \Sabre\BargainFinderMax\Structs\RetailerRulesType
     */
    public function addToRetailerRule(\Sabre\BargainFinderMax\Structs\RetailerRule $item)
    {
        $this->RetailerRule[] = $item;
        return $this;
    }
    /**
     * Get Force value
     * @return bool|null
     */
    public function getForce()
    {
        return $this->Force;
    }
    /**
     * Set Force value
     * @param bool $force
     * @return \Sabre\BargainFinderMax\Structs\RetailerRulesType
     */
    public function setForce($force = false)
    {
        $this->Force = $force;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\RetailerRulesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
