<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReissueType Structs
 * @subpackage Structs
 */
class ReissueType extends AbstractStructBase
{
    /**
     * The ChangeFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ChangeFeeType[]
     */
    public $ChangeFee;
    /**
     * The Tag7Result
     * Meta informations extracted from the WSDL
     * - documentation: Reissue Result from tag 7
     * - use: optional
     * @var bool
     */
    public $Tag7Result;
    /**
     * The FormOfRefund
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FormOfRefund;
    /**
     * The ElectronicTicketRequired
     * Meta informations extracted from the WSDL
     * - documentation: Reissue Requires Electronic Ticket
     * - use: optional
     * @var bool
     */
    public $ElectronicTicketRequired;
    /**
     * The ElectronicTicketNotAllowed
     * Meta informations extracted from the WSDL
     * - documentation: Reissue Does Not Allow Electric Ticket
     * - use: optional
     * @var bool
     */
    public $ElectronicTicketNotAllowed;
    /**
     * The Residual
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Residual;
    /**
     * Constructor method for ReissueType
     * @uses ReissueType::setChangeFee()
     * @uses ReissueType::setTag7Result()
     * @uses ReissueType::setFormOfRefund()
     * @uses ReissueType::setElectronicTicketRequired()
     * @uses ReissueType::setElectronicTicketNotAllowed()
     * @uses ReissueType::setResidual()
     * @param \Sabre\BargainFinderMax\Structs\ChangeFeeType[] $changeFee
     * @param bool $tag7Result
     * @param string $formOfRefund
     * @param bool $electronicTicketRequired
     * @param bool $electronicTicketNotAllowed
     * @param string $residual
     */
    public function __construct(array $changeFee = array(), $tag7Result = null, $formOfRefund = null, $electronicTicketRequired = null, $electronicTicketNotAllowed = null, $residual = null)
    {
        $this
            ->setChangeFee($changeFee)
            ->setTag7Result($tag7Result)
            ->setFormOfRefund($formOfRefund)
            ->setElectronicTicketRequired($electronicTicketRequired)
            ->setElectronicTicketNotAllowed($electronicTicketNotAllowed)
            ->setResidual($residual);
    }
    /**
     * Get ChangeFee value
     * @return \Sabre\BargainFinderMax\Structs\ChangeFeeType[]|null
     */
    public function getChangeFee()
    {
        return $this->ChangeFee;
    }
    /**
     * Set ChangeFee value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ChangeFeeType[] $changeFee
     * @return \Sabre\BargainFinderMax\Structs\ReissueType
     */
    public function setChangeFee(array $changeFee = array())
    {
        $this->ChangeFee = $changeFee;
        return $this;
    }
    /**
     * Add item to ChangeFee value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ChangeFeeType $item
     * @return \Sabre\BargainFinderMax\Structs\ReissueType
     */
    public function addToChangeFee(\Sabre\BargainFinderMax\Structs\ChangeFeeType $item)
    {
        $this->ChangeFee[] = $item;
        return $this;
    }
    /**
     * Get Tag7Result value
     * @return bool|null
     */
    public function getTag7Result()
    {
        return $this->Tag7Result;
    }
    /**
     * Set Tag7Result value
     * @param bool $tag7Result
     * @return \Sabre\BargainFinderMax\Structs\ReissueType
     */
    public function setTag7Result($tag7Result = null)
    {
        $this->Tag7Result = $tag7Result;
        return $this;
    }
    /**
     * Get FormOfRefund value
     * @return string|null
     */
    public function getFormOfRefund()
    {
        return $this->FormOfRefund;
    }
    /**
     * Set FormOfRefund value
     * @param string $formOfRefund
     * @return \Sabre\BargainFinderMax\Structs\ReissueType
     */
    public function setFormOfRefund($formOfRefund = null)
    {
        $this->FormOfRefund = $formOfRefund;
        return $this;
    }
    /**
     * Get ElectronicTicketRequired value
     * @return bool|null
     */
    public function getElectronicTicketRequired()
    {
        return $this->ElectronicTicketRequired;
    }
    /**
     * Set ElectronicTicketRequired value
     * @param bool $electronicTicketRequired
     * @return \Sabre\BargainFinderMax\Structs\ReissueType
     */
    public function setElectronicTicketRequired($electronicTicketRequired = null)
    {
        $this->ElectronicTicketRequired = $electronicTicketRequired;
        return $this;
    }
    /**
     * Get ElectronicTicketNotAllowed value
     * @return bool|null
     */
    public function getElectronicTicketNotAllowed()
    {
        return $this->ElectronicTicketNotAllowed;
    }
    /**
     * Set ElectronicTicketNotAllowed value
     * @param bool $electronicTicketNotAllowed
     * @return \Sabre\BargainFinderMax\Structs\ReissueType
     */
    public function setElectronicTicketNotAllowed($electronicTicketNotAllowed = null)
    {
        $this->ElectronicTicketNotAllowed = $electronicTicketNotAllowed;
        return $this;
    }
    /**
     * Get Residual value
     * @return string|null
     */
    public function getResidual()
    {
        return $this->Residual;
    }
    /**
     * Set Residual value
     * @param string $residual
     * @return \Sabre\BargainFinderMax\Structs\ReissueType
     */
    public function setResidual($residual = null)
    {
        $this->Residual = $residual;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ReissueType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
