<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessingMessageType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Message generated per for particular date and leg
 * @subpackage Structs
 */
class ProcessingMessageType extends AbstractStructBase
{
    /**
     * The PricingSource
     * Meta informations extracted from the WSDL
     * - documentation: Pricing source. | It can be used to indicate whether the fare is public or private.
     * - use: required
     * - pattern: [0-9A-Z_]{1,13}
     * @var string
     */
    public $PricingSource;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Message text
     * - use: required
     * @var string
     */
    public $Message;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Text;
    /**
     * Constructor method for ProcessingMessageType
     * @uses ProcessingMessageType::setPricingSource()
     * @uses ProcessingMessageType::setMessage()
     * @uses ProcessingMessageType::setText()
     * @param string $pricingSource
     * @param string $message
     * @param string $text
     */
    public function __construct($pricingSource = null, $message = null, $text = null)
    {
        $this
            ->setPricingSource($pricingSource)
            ->setMessage($message)
            ->setText($text);
    }
    /**
     * Get PricingSource value
     * @return string
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @param string $pricingSource
     * @return \Sabre\BargainFinderMax\Structs\ProcessingMessageType
     */
    public function setPricingSource($pricingSource = null)
    {
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Get Message value
     * @return string
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Sabre\BargainFinderMax\Structs\ProcessingMessageType
     */
    public function setMessage($message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Text value
     * @return string
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\BargainFinderMax\Structs\ProcessingMessageType
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ProcessingMessageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
