<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedItinerariesType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Container for priced itineraries.
 * @subpackage Structs
 */
class PricedItinerariesType extends AbstractStructBase
{
    /**
     * The PricedItinerary
     * Meta informations extracted from the WSDL
     * - documentation: Container for priced itinerary type.
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\PricedItineraryType[]
     */
    public $PricedItinerary;
    /**
     * Constructor method for PricedItinerariesType
     * @uses PricedItinerariesType::setPricedItinerary()
     * @param \Sabre\BargainFinderMax\Structs\PricedItineraryType[] $pricedItinerary
     */
    public function __construct(array $pricedItinerary = array())
    {
        $this
            ->setPricedItinerary($pricedItinerary);
    }
    /**
     * Get PricedItinerary value
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType[]|null
     */
    public function getPricedItinerary()
    {
        return $this->PricedItinerary;
    }
    /**
     * Set PricedItinerary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PricedItineraryType[] $pricedItinerary
     * @return \Sabre\BargainFinderMax\Structs\PricedItinerariesType
     */
    public function setPricedItinerary(array $pricedItinerary = array())
    {
        $this->PricedItinerary = $pricedItinerary;
        return $this;
    }
    /**
     * Add item to PricedItinerary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PricedItineraryType $item
     * @return \Sabre\BargainFinderMax\Structs\PricedItinerariesType
     */
    public function addToPricedItinerary(\Sabre\BargainFinderMax\Structs\PricedItineraryType $item)
    {
        $this->PricedItinerary[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\PricedItinerariesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
