<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlusUpInformationType Structs
 * @subpackage Structs
 */
class PlusUpInformationType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Plus Up Amount
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - documentation: Plus Up Origin City | City code type
     * - use: required
     * - length: 3
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - documentation: Plus Up Destination City | City code type
     * - use: required
     * - length: 3
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $Destination;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Plus Up Message
     * - use: required
     * @var string
     */
    public $Message;
    /**
     * The FareOrigin
     * Meta informations extracted from the WSDL
     * - documentation: Plus Up Fare Origin City | City code type
     * - use: optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $FareOrigin;
    /**
     * The FareDestination
     * Meta informations extracted from the WSDL
     * - documentation: Plus Up Fare Destination City | City code type
     * - use: optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $FareDestination;
    /**
     * The CountryOfPayment
     * Meta informations extracted from the WSDL
     * - documentation: Plus Up Country of Payment | Country code type
     * - use: optional
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $CountryOfPayment;
    /**
     * The ViaCity
     * Meta informations extracted from the WSDL
     * - documentation: Plus Up Via City | City code type
     * - use: optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $ViaCity;
    /**
     * Constructor method for PlusUpInformationType
     * @uses PlusUpInformationType::setAmount()
     * @uses PlusUpInformationType::setOrigin()
     * @uses PlusUpInformationType::setDestination()
     * @uses PlusUpInformationType::setMessage()
     * @uses PlusUpInformationType::setFareOrigin()
     * @uses PlusUpInformationType::setFareDestination()
     * @uses PlusUpInformationType::setCountryOfPayment()
     * @uses PlusUpInformationType::setViaCity()
     * @param float $amount
     * @param string $origin
     * @param string $destination
     * @param string $message
     * @param string $fareOrigin
     * @param string $fareDestination
     * @param string $countryOfPayment
     * @param string $viaCity
     */
    public function __construct($amount = null, $origin = null, $destination = null, $message = null, $fareOrigin = null, $fareDestination = null, $countryOfPayment = null, $viaCity = null)
    {
        $this
            ->setAmount($amount)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setMessage($message)
            ->setFareOrigin($fareOrigin)
            ->setFareDestination($fareDestination)
            ->setCountryOfPayment($countryOfPayment)
            ->setViaCity($viaCity);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\BargainFinderMax\Structs\PlusUpInformationType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Origin value
     * @return string
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \Sabre\BargainFinderMax\Structs\PlusUpInformationType
     */
    public function setOrigin($origin = null)
    {
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \Sabre\BargainFinderMax\Structs\PlusUpInformationType
     */
    public function setDestination($destination = null)
    {
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get Message value
     * @return string
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Sabre\BargainFinderMax\Structs\PlusUpInformationType
     */
    public function setMessage($message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get FareOrigin value
     * @return string|null
     */
    public function getFareOrigin()
    {
        return $this->FareOrigin;
    }
    /**
     * Set FareOrigin value
     * @param string $fareOrigin
     * @return \Sabre\BargainFinderMax\Structs\PlusUpInformationType
     */
    public function setFareOrigin($fareOrigin = null)
    {
        $this->FareOrigin = $fareOrigin;
        return $this;
    }
    /**
     * Get FareDestination value
     * @return string|null
     */
    public function getFareDestination()
    {
        return $this->FareDestination;
    }
    /**
     * Set FareDestination value
     * @param string $fareDestination
     * @return \Sabre\BargainFinderMax\Structs\PlusUpInformationType
     */
    public function setFareDestination($fareDestination = null)
    {
        $this->FareDestination = $fareDestination;
        return $this;
    }
    /**
     * Get CountryOfPayment value
     * @return string|null
     */
    public function getCountryOfPayment()
    {
        return $this->CountryOfPayment;
    }
    /**
     * Set CountryOfPayment value
     * @param string $countryOfPayment
     * @return \Sabre\BargainFinderMax\Structs\PlusUpInformationType
     */
    public function setCountryOfPayment($countryOfPayment = null)
    {
        $this->CountryOfPayment = $countryOfPayment;
        return $this;
    }
    /**
     * Get ViaCity value
     * @return string|null
     */
    public function getViaCity()
    {
        return $this->ViaCity;
    }
    /**
     * Set ViaCity value
     * @param string $viaCity
     * @return \Sabre\BargainFinderMax\Structs\PlusUpInformationType
     */
    public function setViaCity($viaCity = null)
    {
        $this->ViaCity = $viaCity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\PlusUpInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
