<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PenaltiesInfo Structs
 * Meta informations extracted from the WSDL
 * - documentation: Penalties information
 * @subpackage Structs
 */
class PenaltiesInfo extends AbstractStructBase
{
    /**
     * The Penalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\Penalty[]
     */
    public $Penalty;
    /**
     * Constructor method for PenaltiesInfo
     * @uses PenaltiesInfo::setPenalty()
     * @param \Sabre\BargainFinderMax\Structs\Penalty[] $penalty
     */
    public function __construct(array $penalty = array())
    {
        $this
            ->setPenalty($penalty);
    }
    /**
     * Get Penalty value
     * @return \Sabre\BargainFinderMax\Structs\Penalty[]|null
     */
    public function getPenalty()
    {
        return $this->Penalty;
    }
    /**
     * Set Penalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Penalty[] $penalty
     * @return \Sabre\BargainFinderMax\Structs\PenaltiesInfo
     */
    public function setPenalty(array $penalty = array())
    {
        $this->Penalty = $penalty;
        return $this;
    }
    /**
     * Add item to Penalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Penalty $item
     * @return \Sabre\BargainFinderMax\Structs\PenaltiesInfo
     */
    public function addToPenalty(\Sabre\BargainFinderMax\Structs\Penalty $item)
    {
        $this->Penalty[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\PenaltiesInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
