<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerNotAvailableInfoType Structs
 * @subpackage Structs
 */
class PassengerNotAvailableInfoType extends AbstractStructBase
{
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - documentation: Passenger type | Passenger code type
     * - use: required
     * - pattern: [A-Z][A-Z0-9]{2}
     * @var string
     */
    public $PassengerType;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - documentation: Reason
     * - use: required
     * @var string
     */
    public $Reason;
    /**
     * Constructor method for PassengerNotAvailableInfoType
     * @uses PassengerNotAvailableInfoType::setPassengerType()
     * @uses PassengerNotAvailableInfoType::setReason()
     * @param string $passengerType
     * @param string $reason
     */
    public function __construct($passengerType = null, $reason = null)
    {
        $this
            ->setPassengerType($passengerType)
            ->setReason($reason);
    }
    /**
     * Get PassengerType value
     * @return string
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param string $passengerType
     * @return \Sabre\BargainFinderMax\Structs\PassengerNotAvailableInfoType
     */
    public function setPassengerType($passengerType = null)
    {
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Get Reason value
     * @return string
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \Sabre\BargainFinderMax\Structs\PassengerNotAvailableInfoType
     */
    public function setReason($reason = null)
    {
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\PassengerNotAvailableInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
