<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Origins Structs
 * @subpackage Structs
 */
class Origins extends AbstractStructBase
{
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\Origin[]
     */
    public $Origin;
    /**
     * Constructor method for Origins
     * @uses Origins::setOrigin()
     * @param \Sabre\BargainFinderMax\Structs\Origin[] $origin
     */
    public function __construct(array $origin = array())
    {
        $this
            ->setOrigin($origin);
    }
    /**
     * Get Origin value
     * @return \Sabre\BargainFinderMax\Structs\Origin[]|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Origin[] $origin
     * @return \Sabre\BargainFinderMax\Structs\Origins
     */
    public function setOrigin(array $origin = array())
    {
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Add item to Origin value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Origin $item
     * @return \Sabre\BargainFinderMax\Structs\Origins
     */
    public function addToOrigin(\Sabre\BargainFinderMax\Structs\Origin $item)
    {
        $this->Origin[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Origins
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
