<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperatingDuplicate Structs
 * @subpackage Structs
 */
class OperatingDuplicate extends AbstractStructBase
{
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxInclusive: 10
     * - minInclusive: 0
     * @var float
     */
    public $Weight;
    /**
     * The PreferredCarrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PreferredCarrier[]
     */
    public $PreferredCarrier;
    /**
     * Constructor method for OperatingDuplicate
     * @uses OperatingDuplicate::setWeight()
     * @uses OperatingDuplicate::setPreferredCarrier()
     * @param float $weight
     * @param \Sabre\BargainFinderMax\Structs\PreferredCarrier[] $preferredCarrier
     */
    public function __construct($weight = null, array $preferredCarrier = array())
    {
        $this
            ->setWeight($weight)
            ->setPreferredCarrier($preferredCarrier);
    }
    /**
     * Get Weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \Sabre\BargainFinderMax\Structs\OperatingDuplicate
     */
    public function setWeight($weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get PreferredCarrier value
     * @return \Sabre\BargainFinderMax\Structs\PreferredCarrier[]|null
     */
    public function getPreferredCarrier()
    {
        return $this->PreferredCarrier;
    }
    /**
     * Set PreferredCarrier value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PreferredCarrier[] $preferredCarrier
     * @return \Sabre\BargainFinderMax\Structs\OperatingDuplicate
     */
    public function setPreferredCarrier(array $preferredCarrier = array())
    {
        $this->PreferredCarrier = $preferredCarrier;
        return $this;
    }
    /**
     * Add item to PreferredCarrier value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PreferredCarrier $item
     * @return \Sabre\BargainFinderMax\Structs\OperatingDuplicate
     */
    public function addToPreferredCarrier(\Sabre\BargainFinderMax\Structs\PreferredCarrier $item)
    {
        $this->PreferredCarrier[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\OperatingDuplicate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
