<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperatingAirlineType Structs
 * Meta informations extracted from the WSDL
 * - documentation: This is an extension of CompanyNameType to include a FlightNumber.
 * @subpackage Structs
 */
class OperatingAirlineType extends CompanyNameType
{
    /**
     * The _
     * @var \Sabre\BargainFinderMax\Structs\CompanyNameType
     */
    public $_;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - documentation: Identifies a flight number (1 to 4 numbers followed by optional uppercase A - Z, which specifies an operational suffix) or OPEN or ARNK.
     * - pattern: [0-9]{1,4}[A-Z]?
     * @var string
     */
    public $FlightNumber;
    /**
     * Constructor method for OperatingAirlineType
     * @uses OperatingAirlineType::set_()
     * @uses OperatingAirlineType::setFlightNumber()
     * @param \Sabre\BargainFinderMax\Structs\CompanyNameType $_
     * @param string $flightNumber
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\CompanyNameType $_ = null, $flightNumber = null)
    {
        $this
            ->set_($_)
            ->setFlightNumber($flightNumber);
    }
    /**
     * Get _ value
     * @return \Sabre\BargainFinderMax\Structs\CompanyNameType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \Sabre\BargainFinderMax\Structs\CompanyNameType $_
     * @return \Sabre\BargainFinderMax\Structs\OperatingAirlineType
     */
    public function set_(\Sabre\BargainFinderMax\Structs\CompanyNameType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \Sabre\BargainFinderMax\Structs\OperatingAirlineType
     */
    public function setFlightNumber($flightNumber = null)
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\OperatingAirlineType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
