<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirLowFareSearchRQ Structs
 * Meta informations extracted from the WSDL
 * - documentation: The Low Fare Search Request message requests priced itinerary options for flights between specific city pairs on specific dates for specific numbers and types of passengers. Optional request information can include: - Time / Time
 * Window - Connecting cities. - Client Preferences (airlines, cabin, flight types etc.) The Low Fare Search request contains similar information to a Low Fare Search entry on an airline CRS or GDS.
 * @subpackage Structs
 */
class OTA_AirLowFareSearchRQ extends AbstractStructBase
{
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - documentation: Point of sale object.
     * @var \Sabre\BargainFinderMax\Structs\POS_Type
     */
    public $POS;
    /**
     * The OriginDestinationInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\OriginDestinationInformation[]
     */
    public $OriginDestinationInformation;
    /**
     * The Leg
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Leg[]
     */
    public $Leg;
    /**
     * The TravelPreferences
     * Meta informations extracted from the WSDL
     * - documentation: Air Low Fare Search Request preference information.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public $TravelPreferences;
    /**
     * The TravelerInfoSummary
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the number of passengers and types for Air Low Fare Search.
     * @var \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType
     */
    public $TravelerInfoSummary;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The DirectFlightsOnly
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Request direct flights between given locations. This defaults to false.
     * - use: optional
     * @var bool
     */
    public $DirectFlightsOnly;
    /**
     * The AvailableFlightsOnly
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Include only flights with available booking codes (when True or when attribute not present).
     * - use: optional
     * @var bool
     */
    public $AvailableFlightsOnly;
    /**
     * The ResponseType
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ResponseType;
    /**
     * The ResponseVersion
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ResponseVersion;
    /**
     * The SeparateMessages
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Whether all messages should be printed in separate MTP element or not. Works only with PSS response serializers.
     * - use: optional
     * @var bool
     */
    public $SeparateMessages;
    /**
     * The TruncateMessages
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether each MTP content should be truncated to specified length or not. Works only with PSS response serializers.
     * - use: optional
     * @var bool
     */
    public $TruncateMessages;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * Meta informations extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * Meta informations extracted from the WSDL
     * - union: positiveInteger | boolean
     * @var string
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The PrimaryLangID
     * @var string
     */
    public $PrimaryLangID;
    /**
     * The AltLangID
     * @var string
     */
    public $AltLangID;
    /**
     * The MaxResponses
     * @var string
     */
    public $MaxResponses;
    /**
     * Constructor method for OTA_AirLowFareSearchRQ
     * @uses OTA_AirLowFareSearchRQ::setPOS()
     * @uses OTA_AirLowFareSearchRQ::setOriginDestinationInformation()
     * @uses OTA_AirLowFareSearchRQ::setLeg()
     * @uses OTA_AirLowFareSearchRQ::setTravelPreferences()
     * @uses OTA_AirLowFareSearchRQ::setTravelerInfoSummary()
     * @uses OTA_AirLowFareSearchRQ::setTPA_Extensions()
     * @uses OTA_AirLowFareSearchRQ::setDirectFlightsOnly()
     * @uses OTA_AirLowFareSearchRQ::setAvailableFlightsOnly()
     * @uses OTA_AirLowFareSearchRQ::setResponseType()
     * @uses OTA_AirLowFareSearchRQ::setResponseVersion()
     * @uses OTA_AirLowFareSearchRQ::setSeparateMessages()
     * @uses OTA_AirLowFareSearchRQ::setTruncateMessages()
     * @uses OTA_AirLowFareSearchRQ::setEchoToken()
     * @uses OTA_AirLowFareSearchRQ::setTimeStamp()
     * @uses OTA_AirLowFareSearchRQ::setTarget()
     * @uses OTA_AirLowFareSearchRQ::setVersion()
     * @uses OTA_AirLowFareSearchRQ::setTransactionIdentifier()
     * @uses OTA_AirLowFareSearchRQ::setSequenceNmbr()
     * @uses OTA_AirLowFareSearchRQ::setTransactionStatusCode()
     * @uses OTA_AirLowFareSearchRQ::setPrimaryLangID()
     * @uses OTA_AirLowFareSearchRQ::setAltLangID()
     * @uses OTA_AirLowFareSearchRQ::setMaxResponses()
     * @param \Sabre\BargainFinderMax\Structs\POS_Type $pOS
     * @param \Sabre\BargainFinderMax\Structs\OriginDestinationInformation[] $originDestinationInformation
     * @param \Sabre\BargainFinderMax\Structs\Leg[] $leg
     * @param \Sabre\BargainFinderMax\Structs\AirSearchPrefsType $travelPreferences
     * @param \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType $travelerInfoSummary
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @param bool $directFlightsOnly
     * @param bool $availableFlightsOnly
     * @param string $responseType
     * @param string $responseVersion
     * @param bool $separateMessages
     * @param bool $truncateMessages
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $version
     * @param string $transactionIdentifier
     * @param string $sequenceNmbr
     * @param string $transactionStatusCode
     * @param string $primaryLangID
     * @param string $altLangID
     * @param string $maxResponses
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\POS_Type $pOS = null, array $originDestinationInformation = array(), array $leg = array(), \Sabre\BargainFinderMax\Structs\AirSearchPrefsType $travelPreferences = null, \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType $travelerInfoSummary = null, \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null, $directFlightsOnly = false, $availableFlightsOnly = true, $responseType = null, $responseVersion = null, $separateMessages = false, $truncateMessages = true, $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $primaryLangID = null, $altLangID = null, $maxResponses = null)
    {
        $this
            ->setPOS($pOS)
            ->setOriginDestinationInformation($originDestinationInformation)
            ->setLeg($leg)
            ->setTravelPreferences($travelPreferences)
            ->setTravelerInfoSummary($travelerInfoSummary)
            ->setTPA_Extensions($tPA_Extensions)
            ->setDirectFlightsOnly($directFlightsOnly)
            ->setAvailableFlightsOnly($availableFlightsOnly)
            ->setResponseType($responseType)
            ->setResponseVersion($responseVersion)
            ->setSeparateMessages($separateMessages)
            ->setTruncateMessages($truncateMessages)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setPrimaryLangID($primaryLangID)
            ->setAltLangID($altLangID)
            ->setMaxResponses($maxResponses);
    }
    /**
     * Get POS value
     * @return \Sabre\BargainFinderMax\Structs\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \Sabre\BargainFinderMax\Structs\POS_Type $pOS
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setPOS(\Sabre\BargainFinderMax\Structs\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get OriginDestinationInformation value
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationInformation[]|null
     */
    public function getOriginDestinationInformation()
    {
        return $this->OriginDestinationInformation;
    }
    /**
     * Set OriginDestinationInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\OriginDestinationInformation[] $originDestinationInformation
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setOriginDestinationInformation(array $originDestinationInformation = array())
    {
        $this->OriginDestinationInformation = $originDestinationInformation;
        return $this;
    }
    /**
     * Add item to OriginDestinationInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\OriginDestinationInformation $item
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function addToOriginDestinationInformation(\Sabre\BargainFinderMax\Structs\OriginDestinationInformation $item)
    {
        $this->OriginDestinationInformation[] = $item;
        return $this;
    }
    /**
     * Get Leg value
     * @return \Sabre\BargainFinderMax\Structs\Leg[]|null
     */
    public function getLeg()
    {
        return $this->Leg;
    }
    /**
     * Set Leg value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Leg[] $leg
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setLeg(array $leg = array())
    {
        $this->Leg = $leg;
        return $this;
    }
    /**
     * Add item to Leg value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Leg $item
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function addToLeg(\Sabre\BargainFinderMax\Structs\Leg $item)
    {
        $this->Leg[] = $item;
        return $this;
    }
    /**
     * Get TravelPreferences value
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType|null
     */
    public function getTravelPreferences()
    {
        return $this->TravelPreferences;
    }
    /**
     * Set TravelPreferences value
     * @param \Sabre\BargainFinderMax\Structs\AirSearchPrefsType $travelPreferences
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setTravelPreferences(\Sabre\BargainFinderMax\Structs\AirSearchPrefsType $travelPreferences = null)
    {
        $this->TravelPreferences = $travelPreferences;
        return $this;
    }
    /**
     * Get TravelerInfoSummary value
     * @return \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType|null
     */
    public function getTravelerInfoSummary()
    {
        return $this->TravelerInfoSummary;
    }
    /**
     * Set TravelerInfoSummary value
     * @param \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType $travelerInfoSummary
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setTravelerInfoSummary(\Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType $travelerInfoSummary = null)
    {
        $this->TravelerInfoSummary = $travelerInfoSummary;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get DirectFlightsOnly value
     * @return bool|null
     */
    public function getDirectFlightsOnly()
    {
        return $this->DirectFlightsOnly;
    }
    /**
     * Set DirectFlightsOnly value
     * @param bool $directFlightsOnly
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setDirectFlightsOnly($directFlightsOnly = false)
    {
        $this->DirectFlightsOnly = $directFlightsOnly;
        return $this;
    }
    /**
     * Get AvailableFlightsOnly value
     * @return bool|null
     */
    public function getAvailableFlightsOnly()
    {
        return $this->AvailableFlightsOnly;
    }
    /**
     * Set AvailableFlightsOnly value
     * @param bool $availableFlightsOnly
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setAvailableFlightsOnly($availableFlightsOnly = true)
    {
        $this->AvailableFlightsOnly = $availableFlightsOnly;
        return $this;
    }
    /**
     * Get ResponseType value
     * @return string|null
     */
    public function getResponseType()
    {
        return $this->ResponseType;
    }
    /**
     * Set ResponseType value
     * @param string $responseType
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setResponseType($responseType = null)
    {
        $this->ResponseType = $responseType;
        return $this;
    }
    /**
     * Get ResponseVersion value
     * @return string|null
     */
    public function getResponseVersion()
    {
        return $this->ResponseVersion;
    }
    /**
     * Set ResponseVersion value
     * @param string $responseVersion
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setResponseVersion($responseVersion = null)
    {
        $this->ResponseVersion = $responseVersion;
        return $this;
    }
    /**
     * Get SeparateMessages value
     * @return bool|null
     */
    public function getSeparateMessages()
    {
        return $this->SeparateMessages;
    }
    /**
     * Set SeparateMessages value
     * @param bool $separateMessages
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setSeparateMessages($separateMessages = false)
    {
        $this->SeparateMessages = $separateMessages;
        return $this;
    }
    /**
     * Get TruncateMessages value
     * @return bool|null
     */
    public function getTruncateMessages()
    {
        return $this->TruncateMessages;
    }
    /**
     * Set TruncateMessages value
     * @param bool $truncateMessages
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setTruncateMessages($truncateMessages = true)
    {
        $this->TruncateMessages = $truncateMessages;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setEchoToken($echoToken = null)
    {
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setTarget($target = null)
    {
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return string|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param string $sequenceNmbr
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get PrimaryLangID value
     * @return string|null
     */
    public function getPrimaryLangID()
    {
        return $this->PrimaryLangID;
    }
    /**
     * Set PrimaryLangID value
     * @param string $primaryLangID
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setPrimaryLangID($primaryLangID = null)
    {
        $this->PrimaryLangID = $primaryLangID;
        return $this;
    }
    /**
     * Get AltLangID value
     * @return string|null
     */
    public function getAltLangID()
    {
        return $this->AltLangID;
    }
    /**
     * Set AltLangID value
     * @param string $altLangID
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setAltLangID($altLangID = null)
    {
        $this->AltLangID = $altLangID;
        return $this;
    }
    /**
     * Get MaxResponses value
     * @return string|null
     */
    public function getMaxResponses()
    {
        return $this->MaxResponses;
    }
    /**
     * Set MaxResponses value
     * @param string $maxResponses
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public function setMaxResponses($maxResponses = null)
    {
        $this->MaxResponses = $maxResponses;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
