<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketingCarrier Structs
 * Meta informations extracted from the WSDL
 * - documentation: Prefer itineraries with marketing carriers in order speciied in Carrier subtags, comparing segment-wise
 * @subpackage Structs
 */
class MarketingCarrier extends AbstractStructBase
{
    /**
     * The Carrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \Sabre\BargainFinderMax\Structs\Carrier[]
     */
    public $Carrier;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxInclusive: 9
     * - minInclusive: 1
     * @var int
     */
    public $Priority;
    /**
     * The Leg
     * Meta informations extracted from the WSDL
     * - documentation: Which leg is most significant one? If inconclusive continue comparisons segment by segment starting from the beginning of itinerary
     * - use: optional
     * @var int
     */
    public $Leg;
    /**
     * Constructor method for MarketingCarrier
     * @uses MarketingCarrier::setCarrier()
     * @uses MarketingCarrier::setPriority()
     * @uses MarketingCarrier::setLeg()
     * @param \Sabre\BargainFinderMax\Structs\Carrier[] $carrier
     * @param int $priority
     * @param int $leg
     */
    public function __construct(array $carrier = array(), $priority = null, $leg = null)
    {
        $this
            ->setCarrier($carrier)
            ->setPriority($priority)
            ->setLeg($leg);
    }
    /**
     * Get Carrier value
     * @return \Sabre\BargainFinderMax\Structs\Carrier[]
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Carrier[] $carrier
     * @return \Sabre\BargainFinderMax\Structs\MarketingCarrier
     */
    public function setCarrier(array $carrier = array())
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Add item to Carrier value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Carrier $item
     * @return \Sabre\BargainFinderMax\Structs\MarketingCarrier
     */
    public function addToCarrier(\Sabre\BargainFinderMax\Structs\Carrier $item)
    {
        $this->Carrier[] = $item;
        return $this;
    }
    /**
     * Get Priority value
     * @return int
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \Sabre\BargainFinderMax\Structs\MarketingCarrier
     */
    public function setPriority($priority = null)
    {
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get Leg value
     * @return int|null
     */
    public function getLeg()
    {
        return $this->Leg;
    }
    /**
     * Set Leg value
     * @param int $leg
     * @return \Sabre\BargainFinderMax\Structs\MarketingCarrier
     */
    public function setLeg($leg = null)
    {
        $this->Leg = $leg;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\MarketingCarrier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
