<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LegType Structs
 * @subpackage Structs
 */
class LegType extends AbstractStructBase
{
    /**
     * The Schedule
     * Meta informations extracted from the WSDL
     * - documentation: Schedule reference, plus departure day offset
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\ScheduleType[]
     */
    public $Schedule;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Leg ID
     * @var int
     */
    public $ID;
    /**
     * Constructor method for LegType
     * @uses LegType::setSchedule()
     * @uses LegType::setID()
     * @param \Sabre\BargainFinderMax\Structs\ScheduleType[] $schedule
     * @param int $iD
     */
    public function __construct(array $schedule = array(), $iD = null)
    {
        $this
            ->setSchedule($schedule)
            ->setID($iD);
    }
    /**
     * Get Schedule value
     * @return \Sabre\BargainFinderMax\Structs\ScheduleType[]|null
     */
    public function getSchedule()
    {
        return $this->Schedule;
    }
    /**
     * Set Schedule value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ScheduleType[] $schedule
     * @return \Sabre\BargainFinderMax\Structs\LegType
     */
    public function setSchedule(array $schedule = array())
    {
        $this->Schedule = $schedule;
        return $this;
    }
    /**
     * Add item to Schedule value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ScheduleType $item
     * @return \Sabre\BargainFinderMax\Structs\LegType
     */
    public function addToSchedule(\Sabre\BargainFinderMax\Structs\ScheduleType $item)
    {
        $this->Schedule[] = $item;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Sabre\BargainFinderMax\Structs\LegType
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\LegType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
