<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterlineBrandsType Structs
 * @subpackage Structs
 */
class InterlineBrandsType extends AbstractStructBase
{
    /**
     * The Brand
     * Meta informations extracted from the WSDL
     * - documentation: Brand list to be returned
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\BrandType[]
     */
    public $Brand;
    /**
     * The ChangeBrandForSoldout
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: If specific XX brand is not available for requested date/flight, another cheapest brand will be returned combined with available XX brand.
     * - use: optional
     * @var bool
     */
    public $ChangeBrandForSoldout;
    /**
     * Constructor method for InterlineBrandsType
     * @uses InterlineBrandsType::setBrand()
     * @uses InterlineBrandsType::setChangeBrandForSoldout()
     * @param \Sabre\BargainFinderMax\Structs\BrandType[] $brand
     * @param bool $changeBrandForSoldout
     */
    public function __construct(array $brand = array(), $changeBrandForSoldout = false)
    {
        $this
            ->setBrand($brand)
            ->setChangeBrandForSoldout($changeBrandForSoldout);
    }
    /**
     * Get Brand value
     * @return \Sabre\BargainFinderMax\Structs\BrandType[]|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\BrandType[] $brand
     * @return \Sabre\BargainFinderMax\Structs\InterlineBrandsType
     */
    public function setBrand(array $brand = array())
    {
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Add item to Brand value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\BrandType $item
     * @return \Sabre\BargainFinderMax\Structs\InterlineBrandsType
     */
    public function addToBrand(\Sabre\BargainFinderMax\Structs\BrandType $item)
    {
        $this->Brand[] = $item;
        return $this;
    }
    /**
     * Get ChangeBrandForSoldout value
     * @return bool|null
     */
    public function getChangeBrandForSoldout()
    {
        return $this->ChangeBrandForSoldout;
    }
    /**
     * Set ChangeBrandForSoldout value
     * @param bool $changeBrandForSoldout
     * @return \Sabre\BargainFinderMax\Structs\InterlineBrandsType
     */
    public function setChangeBrandForSoldout($changeBrandForSoldout = false)
    {
        $this->ChangeBrandForSoldout = $changeBrandForSoldout;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\InterlineBrandsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
