<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IATAFare Structs
 * Meta informations extracted from the WSDL
 * - documentation: This element finds only IATA fares.
 * @subpackage Structs
 */
class IATAFare extends AbstractStructBase
{
    /**
     * The Ind
     * Meta informations extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $Ind;
    /**
     * Constructor method for IATAFare
     * @uses IATAFare::setInd()
     * @param bool $ind
     */
    public function __construct($ind = false)
    {
        $this
            ->setInd($ind);
    }
    /**
     * Get Ind value
     * @return bool|null
     */
    public function getInd()
    {
        return $this->Ind;
    }
    /**
     * Set Ind value
     * @param bool $ind
     * @return \Sabre\BargainFinderMax\Structs\IATAFare
     */
    public function setInd($ind = false)
    {
        $this->Ind = $ind;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\IATAFare
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
