<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HigherIntermediatePointType Structs
 * @subpackage Structs
 */
class HigherIntermediatePointType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Amount HIP
     * - use: optional
     * @var float
     */
    public $Amount;
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - documentation: Origin City HIP | City code type
     * - use: optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - documentation: Destination City HIP | City code type
     * - use: optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $Destination;
    /**
     * The LowOrigin
     * Meta informations extracted from the WSDL
     * - documentation: Low Origin City HIP | Airport code type
     * - use: optional | optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * - type: UpperCaseAlphaNumericLength3to5
     * @var string
     */
    public $LowOrigin;
    /**
     * The LowDestination
     * Meta informations extracted from the WSDL
     * - documentation: Low Destination City HIP | Airport code type
     * - use: optional | optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * - type: UpperCaseAlphaNumericLength3to5
     * @var string
     */
    public $LowDestination;
    /**
     * The HighOrigin
     * Meta informations extracted from the WSDL
     * - documentation: High Origin City HIP | Airport code type
     * - use: optional | optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * - type: UpperCaseAlphaNumericLength3to5
     * @var string
     */
    public $HighOrigin;
    /**
     * The HighDestination
     * Meta informations extracted from the WSDL
     * - documentation: High Destination City HIP | Airport code type
     * - use: optional | optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * - type: UpperCaseAlphaNumericLength3to5
     * @var string
     */
    public $HighDestination;
    /**
     * The FareClassLow
     * Meta informations extracted from the WSDL
     * - documentation: Fare Class Low
     * - use: optional
     * - maxLength: 15
     * - minLength: 1
     * - pattern: [A-Z0-9]+(/[A-Z0-9]+)?
     * @var string
     */
    public $FareClassLow;
    /**
     * The FareClassHigh
     * Meta informations extracted from the WSDL
     * - documentation: Fare Class High
     * - use: optional
     * - maxLength: 15
     * - minLength: 1
     * - pattern: [A-Z0-9]+(/[A-Z0-9]+)?
     * @var string
     */
    public $FareClassHigh;
    /**
     * The CabinLow
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CabinLow;
    /**
     * The CabinHigh
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CabinHigh;
    /**
     * The MileageSurchargePercentage
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MileageSurchargePercentage;
    /**
     * Constructor method for HigherIntermediatePointType
     * @uses HigherIntermediatePointType::setAmount()
     * @uses HigherIntermediatePointType::setOrigin()
     * @uses HigherIntermediatePointType::setDestination()
     * @uses HigherIntermediatePointType::setLowOrigin()
     * @uses HigherIntermediatePointType::setLowDestination()
     * @uses HigherIntermediatePointType::setHighOrigin()
     * @uses HigherIntermediatePointType::setHighDestination()
     * @uses HigherIntermediatePointType::setFareClassLow()
     * @uses HigherIntermediatePointType::setFareClassHigh()
     * @uses HigherIntermediatePointType::setCabinLow()
     * @uses HigherIntermediatePointType::setCabinHigh()
     * @uses HigherIntermediatePointType::setMileageSurchargePercentage()
     * @param float $amount
     * @param string $origin
     * @param string $destination
     * @param string $lowOrigin
     * @param string $lowDestination
     * @param string $highOrigin
     * @param string $highDestination
     * @param string $fareClassLow
     * @param string $fareClassHigh
     * @param string $cabinLow
     * @param string $cabinHigh
     * @param string $mileageSurchargePercentage
     */
    public function __construct($amount = null, $origin = null, $destination = null, $lowOrigin = null, $lowDestination = null, $highOrigin = null, $highDestination = null, $fareClassLow = null, $fareClassHigh = null, $cabinLow = null, $cabinHigh = null, $mileageSurchargePercentage = null)
    {
        $this
            ->setAmount($amount)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setLowOrigin($lowOrigin)
            ->setLowDestination($lowDestination)
            ->setHighOrigin($highOrigin)
            ->setHighDestination($highDestination)
            ->setFareClassLow($fareClassLow)
            ->setFareClassHigh($fareClassHigh)
            ->setCabinLow($cabinLow)
            ->setCabinHigh($cabinHigh)
            ->setMileageSurchargePercentage($mileageSurchargePercentage);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType
     */
    public function setOrigin($origin = null)
    {
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType
     */
    public function setDestination($destination = null)
    {
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get LowOrigin value
     * @return string|null
     */
    public function getLowOrigin()
    {
        return $this->LowOrigin;
    }
    /**
     * Set LowOrigin value
     * @param string $lowOrigin
     * @return \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType
     */
    public function setLowOrigin($lowOrigin = null)
    {
        $this->LowOrigin = $lowOrigin;
        return $this;
    }
    /**
     * Get LowDestination value
     * @return string|null
     */
    public function getLowDestination()
    {
        return $this->LowDestination;
    }
    /**
     * Set LowDestination value
     * @param string $lowDestination
     * @return \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType
     */
    public function setLowDestination($lowDestination = null)
    {
        $this->LowDestination = $lowDestination;
        return $this;
    }
    /**
     * Get HighOrigin value
     * @return string|null
     */
    public function getHighOrigin()
    {
        return $this->HighOrigin;
    }
    /**
     * Set HighOrigin value
     * @param string $highOrigin
     * @return \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType
     */
    public function setHighOrigin($highOrigin = null)
    {
        $this->HighOrigin = $highOrigin;
        return $this;
    }
    /**
     * Get HighDestination value
     * @return string|null
     */
    public function getHighDestination()
    {
        return $this->HighDestination;
    }
    /**
     * Set HighDestination value
     * @param string $highDestination
     * @return \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType
     */
    public function setHighDestination($highDestination = null)
    {
        $this->HighDestination = $highDestination;
        return $this;
    }
    /**
     * Get FareClassLow value
     * @return string|null
     */
    public function getFareClassLow()
    {
        return $this->FareClassLow;
    }
    /**
     * Set FareClassLow value
     * @param string $fareClassLow
     * @return \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType
     */
    public function setFareClassLow($fareClassLow = null)
    {
        $this->FareClassLow = $fareClassLow;
        return $this;
    }
    /**
     * Get FareClassHigh value
     * @return string|null
     */
    public function getFareClassHigh()
    {
        return $this->FareClassHigh;
    }
    /**
     * Set FareClassHigh value
     * @param string $fareClassHigh
     * @return \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType
     */
    public function setFareClassHigh($fareClassHigh = null)
    {
        $this->FareClassHigh = $fareClassHigh;
        return $this;
    }
    /**
     * Get CabinLow value
     * @return string|null
     */
    public function getCabinLow()
    {
        return $this->CabinLow;
    }
    /**
     * Set CabinLow value
     * @param string $cabinLow
     * @return \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType
     */
    public function setCabinLow($cabinLow = null)
    {
        $this->CabinLow = $cabinLow;
        return $this;
    }
    /**
     * Get CabinHigh value
     * @return string|null
     */
    public function getCabinHigh()
    {
        return $this->CabinHigh;
    }
    /**
     * Set CabinHigh value
     * @param string $cabinHigh
     * @return \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType
     */
    public function setCabinHigh($cabinHigh = null)
    {
        $this->CabinHigh = $cabinHigh;
        return $this;
    }
    /**
     * Get MileageSurchargePercentage value
     * @return string|null
     */
    public function getMileageSurchargePercentage()
    {
        return $this->MileageSurchargePercentage;
    }
    /**
     * Set MileageSurchargePercentage value
     * @param string $mileageSurchargePercentage
     * @return \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType
     */
    public function setMileageSurchargePercentage($mileageSurchargePercentage = null)
    {
        $this->MileageSurchargePercentage = $mileageSurchargePercentage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
