<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupedItineraryResponse Structs
 * Meta informations extracted from the WSDL
 * - documentation: Grouped Itinerary Response Type
 * @subpackage Structs
 */
class GroupedItineraryResponse extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - documentation: Response version | Response Version type
     * - use: required
     * @var string
     */
    public $Version;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Server Message
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\MessageType[]
     */
    public $Message;
    /**
     * The Statistics
     * Meta informations extracted from the WSDL
     * - documentation: Response statistics
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\StatisticsType
     */
    public $Statistics;
    /**
     * The ScheduleMessage
     * Meta informations extracted from the WSDL
     * - documentation: Schedule Global Message
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ScheduleMessageType[]
     */
    public $ScheduleMessage;
    /**
     * The ScheduleDesc
     * Meta informations extracted from the WSDL
     * - documentation: Schedule information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ScheduleDescType[]
     */
    public $ScheduleDesc;
    /**
     * The TaxDesc
     * Meta informations extracted from the WSDL
     * - documentation: Tax information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TaxType[]
     */
    public $TaxDesc;
    /**
     * The TaxSummaryDesc
     * Meta informations extracted from the WSDL
     * - documentation: Tax summary information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TaxSummaryType[]
     */
    public $TaxSummaryDesc;
    /**
     * The OBFeeDesc
     * Meta informations extracted from the WSDL
     * - documentation: OB Fee information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\OBFeeType[]
     */
    public $OBFeeDesc;
    /**
     * The BrandFeatureDesc
     * Meta informations extracted from the WSDL
     * - documentation: Features Table (166) information (ancillaries attached to brand)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\BrandFeatureType[]
     */
    public $BrandFeatureDesc;
    /**
     * The FareComponentDesc
     * Meta informations extracted from the WSDL
     * - documentation: Fare calculation information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FareComponentType[]
     */
    public $FareComponentDesc;
    /**
     * The ValidatingCarrierDesc
     * Meta informations extracted from the WSDL
     * - documentation: Validating Carrier information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ValidatingCarrierType[]
     */
    public $ValidatingCarrierDesc;
    /**
     * The BaggageAllowanceDesc
     * Meta informations extracted from the WSDL
     * - documentation: Baggage Allowance information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\BaggageAllowanceType[]
     */
    public $BaggageAllowanceDesc;
    /**
     * The BaggageChargeDesc
     * Meta informations extracted from the WSDL
     * - documentation: Baggage Allowance information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\BaggageChargeType[]
     */
    public $BaggageChargeDesc;
    /**
     * The CacheSourceDesc
     * Meta informations extracted from the WSDL
     * - documentation: Cache Source information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CacheSourceDescType[]
     */
    public $CacheSourceDesc;
    /**
     * The LegDesc
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\LegType[]
     */
    public $LegDesc;
    /**
     * The ItineraryGroup
     * Meta informations extracted from the WSDL
     * - documentation: Itinerary group
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ItineraryGroupType[]
     */
    public $ItineraryGroup;
    /**
     * Constructor method for GroupedItineraryResponse
     * @uses GroupedItineraryResponse::setVersion()
     * @uses GroupedItineraryResponse::setMessage()
     * @uses GroupedItineraryResponse::setStatistics()
     * @uses GroupedItineraryResponse::setScheduleMessage()
     * @uses GroupedItineraryResponse::setScheduleDesc()
     * @uses GroupedItineraryResponse::setTaxDesc()
     * @uses GroupedItineraryResponse::setTaxSummaryDesc()
     * @uses GroupedItineraryResponse::setOBFeeDesc()
     * @uses GroupedItineraryResponse::setBrandFeatureDesc()
     * @uses GroupedItineraryResponse::setFareComponentDesc()
     * @uses GroupedItineraryResponse::setValidatingCarrierDesc()
     * @uses GroupedItineraryResponse::setBaggageAllowanceDesc()
     * @uses GroupedItineraryResponse::setBaggageChargeDesc()
     * @uses GroupedItineraryResponse::setCacheSourceDesc()
     * @uses GroupedItineraryResponse::setLegDesc()
     * @uses GroupedItineraryResponse::setItineraryGroup()
     * @param string $version
     * @param \Sabre\BargainFinderMax\Structs\MessageType[] $message
     * @param \Sabre\BargainFinderMax\Structs\StatisticsType $statistics
     * @param \Sabre\BargainFinderMax\Structs\ScheduleMessageType[] $scheduleMessage
     * @param \Sabre\BargainFinderMax\Structs\ScheduleDescType[] $scheduleDesc
     * @param \Sabre\BargainFinderMax\Structs\TaxType[] $taxDesc
     * @param \Sabre\BargainFinderMax\Structs\TaxSummaryType[] $taxSummaryDesc
     * @param \Sabre\BargainFinderMax\Structs\OBFeeType[] $oBFeeDesc
     * @param \Sabre\BargainFinderMax\Structs\BrandFeatureType[] $brandFeatureDesc
     * @param \Sabre\BargainFinderMax\Structs\FareComponentType[] $fareComponentDesc
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrierType[] $validatingCarrierDesc
     * @param \Sabre\BargainFinderMax\Structs\BaggageAllowanceType[] $baggageAllowanceDesc
     * @param \Sabre\BargainFinderMax\Structs\BaggageChargeType[] $baggageChargeDesc
     * @param \Sabre\BargainFinderMax\Structs\CacheSourceDescType[] $cacheSourceDesc
     * @param \Sabre\BargainFinderMax\Structs\LegType[] $legDesc
     * @param \Sabre\BargainFinderMax\Structs\ItineraryGroupType[] $itineraryGroup
     */
    public function __construct($version = null, array $message = array(), \Sabre\BargainFinderMax\Structs\StatisticsType $statistics = null, array $scheduleMessage = array(), array $scheduleDesc = array(), array $taxDesc = array(), array $taxSummaryDesc = array(), array $oBFeeDesc = array(), array $brandFeatureDesc = array(), array $fareComponentDesc = array(), array $validatingCarrierDesc = array(), array $baggageAllowanceDesc = array(), array $baggageChargeDesc = array(), array $cacheSourceDesc = array(), array $legDesc = array(), array $itineraryGroup = array())
    {
        $this
            ->setVersion($version)
            ->setMessage($message)
            ->setStatistics($statistics)
            ->setScheduleMessage($scheduleMessage)
            ->setScheduleDesc($scheduleDesc)
            ->setTaxDesc($taxDesc)
            ->setTaxSummaryDesc($taxSummaryDesc)
            ->setOBFeeDesc($oBFeeDesc)
            ->setBrandFeatureDesc($brandFeatureDesc)
            ->setFareComponentDesc($fareComponentDesc)
            ->setValidatingCarrierDesc($validatingCarrierDesc)
            ->setBaggageAllowanceDesc($baggageAllowanceDesc)
            ->setBaggageChargeDesc($baggageChargeDesc)
            ->setCacheSourceDesc($cacheSourceDesc)
            ->setLegDesc($legDesc)
            ->setItineraryGroup($itineraryGroup);
    }
    /**
     * Get Version value
     * @return string
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Message value
     * @return \Sabre\BargainFinderMax\Structs\MessageType[]|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\MessageType[] $message
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function setMessage(array $message = array())
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Add item to Message value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\MessageType $item
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function addToMessage(\Sabre\BargainFinderMax\Structs\MessageType $item)
    {
        $this->Message[] = $item;
        return $this;
    }
    /**
     * Get Statistics value
     * @return \Sabre\BargainFinderMax\Structs\StatisticsType|null
     */
    public function getStatistics()
    {
        return $this->Statistics;
    }
    /**
     * Set Statistics value
     * @param \Sabre\BargainFinderMax\Structs\StatisticsType $statistics
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function setStatistics(\Sabre\BargainFinderMax\Structs\StatisticsType $statistics = null)
    {
        $this->Statistics = $statistics;
        return $this;
    }
    /**
     * Get ScheduleMessage value
     * @return \Sabre\BargainFinderMax\Structs\ScheduleMessageType[]|null
     */
    public function getScheduleMessage()
    {
        return $this->ScheduleMessage;
    }
    /**
     * Set ScheduleMessage value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ScheduleMessageType[] $scheduleMessage
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function setScheduleMessage(array $scheduleMessage = array())
    {
        $this->ScheduleMessage = $scheduleMessage;
        return $this;
    }
    /**
     * Add item to ScheduleMessage value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ScheduleMessageType $item
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function addToScheduleMessage(\Sabre\BargainFinderMax\Structs\ScheduleMessageType $item)
    {
        $this->ScheduleMessage[] = $item;
        return $this;
    }
    /**
     * Get ScheduleDesc value
     * @return \Sabre\BargainFinderMax\Structs\ScheduleDescType[]|null
     */
    public function getScheduleDesc()
    {
        return $this->ScheduleDesc;
    }
    /**
     * Set ScheduleDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ScheduleDescType[] $scheduleDesc
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function setScheduleDesc(array $scheduleDesc = array())
    {
        $this->ScheduleDesc = $scheduleDesc;
        return $this;
    }
    /**
     * Add item to ScheduleDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ScheduleDescType $item
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function addToScheduleDesc(\Sabre\BargainFinderMax\Structs\ScheduleDescType $item)
    {
        $this->ScheduleDesc[] = $item;
        return $this;
    }
    /**
     * Get TaxDesc value
     * @return \Sabre\BargainFinderMax\Structs\TaxType[]|null
     */
    public function getTaxDesc()
    {
        return $this->TaxDesc;
    }
    /**
     * Set TaxDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxType[] $taxDesc
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function setTaxDesc(array $taxDesc = array())
    {
        $this->TaxDesc = $taxDesc;
        return $this;
    }
    /**
     * Add item to TaxDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxType $item
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function addToTaxDesc(\Sabre\BargainFinderMax\Structs\TaxType $item)
    {
        $this->TaxDesc[] = $item;
        return $this;
    }
    /**
     * Get TaxSummaryDesc value
     * @return \Sabre\BargainFinderMax\Structs\TaxSummaryType[]|null
     */
    public function getTaxSummaryDesc()
    {
        return $this->TaxSummaryDesc;
    }
    /**
     * Set TaxSummaryDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxSummaryType[] $taxSummaryDesc
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function setTaxSummaryDesc(array $taxSummaryDesc = array())
    {
        $this->TaxSummaryDesc = $taxSummaryDesc;
        return $this;
    }
    /**
     * Add item to TaxSummaryDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxSummaryType $item
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function addToTaxSummaryDesc(\Sabre\BargainFinderMax\Structs\TaxSummaryType $item)
    {
        $this->TaxSummaryDesc[] = $item;
        return $this;
    }
    /**
     * Get OBFeeDesc value
     * @return \Sabre\BargainFinderMax\Structs\OBFeeType[]|null
     */
    public function getOBFeeDesc()
    {
        return $this->OBFeeDesc;
    }
    /**
     * Set OBFeeDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\OBFeeType[] $oBFeeDesc
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function setOBFeeDesc(array $oBFeeDesc = array())
    {
        $this->OBFeeDesc = $oBFeeDesc;
        return $this;
    }
    /**
     * Add item to OBFeeDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\OBFeeType $item
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function addToOBFeeDesc(\Sabre\BargainFinderMax\Structs\OBFeeType $item)
    {
        $this->OBFeeDesc[] = $item;
        return $this;
    }
    /**
     * Get BrandFeatureDesc value
     * @return \Sabre\BargainFinderMax\Structs\BrandFeatureType[]|null
     */
    public function getBrandFeatureDesc()
    {
        return $this->BrandFeatureDesc;
    }
    /**
     * Set BrandFeatureDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\BrandFeatureType[] $brandFeatureDesc
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function setBrandFeatureDesc(array $brandFeatureDesc = array())
    {
        $this->BrandFeatureDesc = $brandFeatureDesc;
        return $this;
    }
    /**
     * Add item to BrandFeatureDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\BrandFeatureType $item
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function addToBrandFeatureDesc(\Sabre\BargainFinderMax\Structs\BrandFeatureType $item)
    {
        $this->BrandFeatureDesc[] = $item;
        return $this;
    }
    /**
     * Get FareComponentDesc value
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType[]|null
     */
    public function getFareComponentDesc()
    {
        return $this->FareComponentDesc;
    }
    /**
     * Set FareComponentDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FareComponentType[] $fareComponentDesc
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function setFareComponentDesc(array $fareComponentDesc = array())
    {
        $this->FareComponentDesc = $fareComponentDesc;
        return $this;
    }
    /**
     * Add item to FareComponentDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FareComponentType $item
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function addToFareComponentDesc(\Sabre\BargainFinderMax\Structs\FareComponentType $item)
    {
        $this->FareComponentDesc[] = $item;
        return $this;
    }
    /**
     * Get ValidatingCarrierDesc value
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierType[]|null
     */
    public function getValidatingCarrierDesc()
    {
        return $this->ValidatingCarrierDesc;
    }
    /**
     * Set ValidatingCarrierDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrierType[] $validatingCarrierDesc
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function setValidatingCarrierDesc(array $validatingCarrierDesc = array())
    {
        $this->ValidatingCarrierDesc = $validatingCarrierDesc;
        return $this;
    }
    /**
     * Add item to ValidatingCarrierDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrierType $item
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function addToValidatingCarrierDesc(\Sabre\BargainFinderMax\Structs\ValidatingCarrierType $item)
    {
        $this->ValidatingCarrierDesc[] = $item;
        return $this;
    }
    /**
     * Get BaggageAllowanceDesc value
     * @return \Sabre\BargainFinderMax\Structs\BaggageAllowanceType[]|null
     */
    public function getBaggageAllowanceDesc()
    {
        return $this->BaggageAllowanceDesc;
    }
    /**
     * Set BaggageAllowanceDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\BaggageAllowanceType[] $baggageAllowanceDesc
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function setBaggageAllowanceDesc(array $baggageAllowanceDesc = array())
    {
        $this->BaggageAllowanceDesc = $baggageAllowanceDesc;
        return $this;
    }
    /**
     * Add item to BaggageAllowanceDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\BaggageAllowanceType $item
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function addToBaggageAllowanceDesc(\Sabre\BargainFinderMax\Structs\BaggageAllowanceType $item)
    {
        $this->BaggageAllowanceDesc[] = $item;
        return $this;
    }
    /**
     * Get BaggageChargeDesc value
     * @return \Sabre\BargainFinderMax\Structs\BaggageChargeType[]|null
     */
    public function getBaggageChargeDesc()
    {
        return $this->BaggageChargeDesc;
    }
    /**
     * Set BaggageChargeDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\BaggageChargeType[] $baggageChargeDesc
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function setBaggageChargeDesc(array $baggageChargeDesc = array())
    {
        $this->BaggageChargeDesc = $baggageChargeDesc;
        return $this;
    }
    /**
     * Add item to BaggageChargeDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\BaggageChargeType $item
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function addToBaggageChargeDesc(\Sabre\BargainFinderMax\Structs\BaggageChargeType $item)
    {
        $this->BaggageChargeDesc[] = $item;
        return $this;
    }
    /**
     * Get CacheSourceDesc value
     * @return \Sabre\BargainFinderMax\Structs\CacheSourceDescType[]|null
     */
    public function getCacheSourceDesc()
    {
        return $this->CacheSourceDesc;
    }
    /**
     * Set CacheSourceDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CacheSourceDescType[] $cacheSourceDesc
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function setCacheSourceDesc(array $cacheSourceDesc = array())
    {
        $this->CacheSourceDesc = $cacheSourceDesc;
        return $this;
    }
    /**
     * Add item to CacheSourceDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CacheSourceDescType $item
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function addToCacheSourceDesc(\Sabre\BargainFinderMax\Structs\CacheSourceDescType $item)
    {
        $this->CacheSourceDesc[] = $item;
        return $this;
    }
    /**
     * Get LegDesc value
     * @return \Sabre\BargainFinderMax\Structs\LegType[]|null
     */
    public function getLegDesc()
    {
        return $this->LegDesc;
    }
    /**
     * Set LegDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\LegType[] $legDesc
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function setLegDesc(array $legDesc = array())
    {
        $this->LegDesc = $legDesc;
        return $this;
    }
    /**
     * Add item to LegDesc value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\LegType $item
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function addToLegDesc(\Sabre\BargainFinderMax\Structs\LegType $item)
    {
        $this->LegDesc[] = $item;
        return $this;
    }
    /**
     * Get ItineraryGroup value
     * @return \Sabre\BargainFinderMax\Structs\ItineraryGroupType[]|null
     */
    public function getItineraryGroup()
    {
        return $this->ItineraryGroup;
    }
    /**
     * Set ItineraryGroup value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ItineraryGroupType[] $itineraryGroup
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function setItineraryGroup(array $itineraryGroup = array())
    {
        $this->ItineraryGroup = $itineraryGroup;
        return $this;
    }
    /**
     * Add item to ItineraryGroup value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ItineraryGroupType $item
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public function addToItineraryGroup(\Sabre\BargainFinderMax\Structs\ItineraryGroupType $item)
    {
        $this->ItineraryGroup[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\GroupedItineraryResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
