<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GlobalDateTimeType Structs
 * @subpackage Structs
 */
class GlobalDateTimeType extends DateTimeType
{
    /**
     * The DateTime
     * Meta informations extracted from the WSDL
     * - documentation: This date should be of the form YYYY-MM-DDTHH:MM:SS. | IntelliSell Date Time type
     * - use: required
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}
     * @var string
     */
    public $DateTime;
    /**
     * Constructor method for GlobalDateTimeType
     * @uses GlobalDateTimeType::setDateTime()
     * @param string $dateTime
     */
    public function __construct($dateTime = null)
    {
        $this
            ->setDateTime($dateTime);
    }
    /**
     * Get DateTime value
     * @return string
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \Sabre\BargainFinderMax\Structs\GlobalDateTimeType
     */
    public function setDateTime($dateTime = null)
    {
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\GlobalDateTimeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
