<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareSegmentType Structs
 * @subpackage Structs
 */
class FareSegmentType extends AbstractStructBase
{
    /**
     * The Surcharge
     * Meta informations extracted from the WSDL
     * - documentation: Surcharges
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\SurchargeType[]
     */
    public $Surcharge;
    /**
     * The SideTrip
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\SideTrip
     */
    public $SideTrip;
    /**
     * The StopoverCharge
     * Meta informations extracted from the WSDL
     * - documentation: City specific stopover charge amount
     * - use: optional
     * @var float
     */
    public $StopoverCharge;
    /**
     * The StopoverChargeCurrency
     * Meta informations extracted from the WSDL
     * - documentation: City specific stopover charge currency | Currency Code type
     * - use: optional | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $StopoverChargeCurrency;
    /**
     * The TransferCharge
     * Meta informations extracted from the WSDL
     * - documentation: Transfer charge
     * - use: optional
     * @var float
     */
    public $TransferCharge;
    /**
     * The ExtraMileageAllowance
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Extra mileage allowance
     * - use: optional
     * @var bool
     */
    public $ExtraMileageAllowance;
    /**
     * The Stopover
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Stopover segment
     * - use: optional
     * @var bool
     */
    public $Stopover;
    /**
     * Constructor method for FareSegmentType
     * @uses FareSegmentType::setSurcharge()
     * @uses FareSegmentType::setSideTrip()
     * @uses FareSegmentType::setStopoverCharge()
     * @uses FareSegmentType::setStopoverChargeCurrency()
     * @uses FareSegmentType::setTransferCharge()
     * @uses FareSegmentType::setExtraMileageAllowance()
     * @uses FareSegmentType::setStopover()
     * @param \Sabre\BargainFinderMax\Structs\SurchargeType[] $surcharge
     * @param \Sabre\BargainFinderMax\Structs\SideTrip $sideTrip
     * @param float $stopoverCharge
     * @param string $stopoverChargeCurrency
     * @param float $transferCharge
     * @param bool $extraMileageAllowance
     * @param bool $stopover
     */
    public function __construct(array $surcharge = array(), \Sabre\BargainFinderMax\Structs\SideTrip $sideTrip = null, $stopoverCharge = null, $stopoverChargeCurrency = null, $transferCharge = null, $extraMileageAllowance = false, $stopover = false)
    {
        $this
            ->setSurcharge($surcharge)
            ->setSideTrip($sideTrip)
            ->setStopoverCharge($stopoverCharge)
            ->setStopoverChargeCurrency($stopoverChargeCurrency)
            ->setTransferCharge($transferCharge)
            ->setExtraMileageAllowance($extraMileageAllowance)
            ->setStopover($stopover);
    }
    /**
     * Get Surcharge value
     * @return \Sabre\BargainFinderMax\Structs\SurchargeType[]|null
     */
    public function getSurcharge()
    {
        return $this->Surcharge;
    }
    /**
     * Set Surcharge value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\SurchargeType[] $surcharge
     * @return \Sabre\BargainFinderMax\Structs\FareSegmentType
     */
    public function setSurcharge(array $surcharge = array())
    {
        $this->Surcharge = $surcharge;
        return $this;
    }
    /**
     * Add item to Surcharge value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\SurchargeType $item
     * @return \Sabre\BargainFinderMax\Structs\FareSegmentType
     */
    public function addToSurcharge(\Sabre\BargainFinderMax\Structs\SurchargeType $item)
    {
        $this->Surcharge[] = $item;
        return $this;
    }
    /**
     * Get SideTrip value
     * @return \Sabre\BargainFinderMax\Structs\SideTrip|null
     */
    public function getSideTrip()
    {
        return $this->SideTrip;
    }
    /**
     * Set SideTrip value
     * @param \Sabre\BargainFinderMax\Structs\SideTrip $sideTrip
     * @return \Sabre\BargainFinderMax\Structs\FareSegmentType
     */
    public function setSideTrip(\Sabre\BargainFinderMax\Structs\SideTrip $sideTrip = null)
    {
        $this->SideTrip = $sideTrip;
        return $this;
    }
    /**
     * Get StopoverCharge value
     * @return float|null
     */
    public function getStopoverCharge()
    {
        return $this->StopoverCharge;
    }
    /**
     * Set StopoverCharge value
     * @param float $stopoverCharge
     * @return \Sabre\BargainFinderMax\Structs\FareSegmentType
     */
    public function setStopoverCharge($stopoverCharge = null)
    {
        $this->StopoverCharge = $stopoverCharge;
        return $this;
    }
    /**
     * Get StopoverChargeCurrency value
     * @return string|null
     */
    public function getStopoverChargeCurrency()
    {
        return $this->StopoverChargeCurrency;
    }
    /**
     * Set StopoverChargeCurrency value
     * @param string $stopoverChargeCurrency
     * @return \Sabre\BargainFinderMax\Structs\FareSegmentType
     */
    public function setStopoverChargeCurrency($stopoverChargeCurrency = null)
    {
        $this->StopoverChargeCurrency = $stopoverChargeCurrency;
        return $this;
    }
    /**
     * Get TransferCharge value
     * @return float|null
     */
    public function getTransferCharge()
    {
        return $this->TransferCharge;
    }
    /**
     * Set TransferCharge value
     * @param float $transferCharge
     * @return \Sabre\BargainFinderMax\Structs\FareSegmentType
     */
    public function setTransferCharge($transferCharge = null)
    {
        $this->TransferCharge = $transferCharge;
        return $this;
    }
    /**
     * Get ExtraMileageAllowance value
     * @return bool|null
     */
    public function getExtraMileageAllowance()
    {
        return $this->ExtraMileageAllowance;
    }
    /**
     * Set ExtraMileageAllowance value
     * @param bool $extraMileageAllowance
     * @return \Sabre\BargainFinderMax\Structs\FareSegmentType
     */
    public function setExtraMileageAllowance($extraMileageAllowance = false)
    {
        $this->ExtraMileageAllowance = $extraMileageAllowance;
        return $this;
    }
    /**
     * Get Stopover value
     * @return bool|null
     */
    public function getStopover()
    {
        return $this->Stopover;
    }
    /**
     * Set Stopover value
     * @param bool $stopover
     * @return \Sabre\BargainFinderMax\Structs\FareSegmentType
     */
    public function setStopover($stopover = false)
    {
        $this->Stopover = $stopover;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareSegmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
