<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareRestrictPrefType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Identifies preferences for airfare restrictions acceptable or not acceptable for a given travel situation.
 * @subpackage Structs
 */
class FareRestrictPrefType extends AbstractStructBase
{
    /**
     * The FareRestriction
     * Meta informations extracted from the WSDL
     * - documentation: Refer to OTA Code List Fare Restriction (FAR). | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - use: optional
     * @var string
     */
    public $FareRestriction;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for FareRestrictPrefType
     * @uses FareRestrictPrefType::setFareRestriction()
     * @uses FareRestrictPrefType::setPreferLevel()
     * @param string $fareRestriction
     * @param string $preferLevel
     */
    public function __construct($fareRestriction = null, $preferLevel = null)
    {
        $this
            ->setFareRestriction($fareRestriction)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get FareRestriction value
     * @return string|null
     */
    public function getFareRestriction()
    {
        return $this->FareRestriction;
    }
    /**
     * Set FareRestriction value
     * @param string $fareRestriction
     * @return \Sabre\BargainFinderMax\Structs\FareRestrictPrefType
     */
    public function setFareRestriction($fareRestriction = null)
    {
        $this->FareRestriction = $fareRestriction;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \Sabre\BargainFinderMax\Enums\PreferLevelType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \Sabre\BargainFinderMax\Structs\FareRestrictPrefType
     */
    public function setPreferLevel($preferLevel = null)
    {
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareRestrictPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
