<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareRestrictPref Structs
 * Meta informations extracted from the WSDL
 * - documentation: Constrains a fare search to those with restrictions that satisfy user-imposed limitations.
 * @subpackage Structs
 */
class FareRestrictPref extends FareRestrictPrefType
{
    /**
     * The AdvResTicketing
     * Meta informations extracted from the WSDL
     * - documentation: Identifies whether advance reservation or ticketing restrictions are acceptable in the search results.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AdvResTicketingType
     */
    public $AdvResTicketing;
    /**
     * The StayRestrictions
     * Meta informations extracted from the WSDL
     * - documentation: Identifies whether restrictions on minimum or maximum stays should be included in the search results.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\StayRestrictionsType
     */
    public $StayRestrictions;
    /**
     * The VoluntaryChanges
     * Meta informations extracted from the WSDL
     * - documentation: Identifies whether penalties associated with voluntary changes should be included in the search results.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\VoluntaryChangesType
     */
    public $VoluntaryChanges;
    /**
     * Constructor method for FareRestrictPref
     * @uses FareRestrictPref::setAdvResTicketing()
     * @uses FareRestrictPref::setStayRestrictions()
     * @uses FareRestrictPref::setVoluntaryChanges()
     * @param \Sabre\BargainFinderMax\Structs\AdvResTicketingType $advResTicketing
     * @param \Sabre\BargainFinderMax\Structs\StayRestrictionsType $stayRestrictions
     * @param \Sabre\BargainFinderMax\Structs\VoluntaryChangesType $voluntaryChanges
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\AdvResTicketingType $advResTicketing = null, \Sabre\BargainFinderMax\Structs\StayRestrictionsType $stayRestrictions = null, \Sabre\BargainFinderMax\Structs\VoluntaryChangesType $voluntaryChanges = null)
    {
        $this
            ->setAdvResTicketing($advResTicketing)
            ->setStayRestrictions($stayRestrictions)
            ->setVoluntaryChanges($voluntaryChanges);
    }
    /**
     * Get AdvResTicketing value
     * @return \Sabre\BargainFinderMax\Structs\AdvResTicketingType|null
     */
    public function getAdvResTicketing()
    {
        return $this->AdvResTicketing;
    }
    /**
     * Set AdvResTicketing value
     * @param \Sabre\BargainFinderMax\Structs\AdvResTicketingType $advResTicketing
     * @return \Sabre\BargainFinderMax\Structs\FareRestrictPref
     */
    public function setAdvResTicketing(\Sabre\BargainFinderMax\Structs\AdvResTicketingType $advResTicketing = null)
    {
        $this->AdvResTicketing = $advResTicketing;
        return $this;
    }
    /**
     * Get StayRestrictions value
     * @return \Sabre\BargainFinderMax\Structs\StayRestrictionsType|null
     */
    public function getStayRestrictions()
    {
        return $this->StayRestrictions;
    }
    /**
     * Set StayRestrictions value
     * @param \Sabre\BargainFinderMax\Structs\StayRestrictionsType $stayRestrictions
     * @return \Sabre\BargainFinderMax\Structs\FareRestrictPref
     */
    public function setStayRestrictions(\Sabre\BargainFinderMax\Structs\StayRestrictionsType $stayRestrictions = null)
    {
        $this->StayRestrictions = $stayRestrictions;
        return $this;
    }
    /**
     * Get VoluntaryChanges value
     * @return \Sabre\BargainFinderMax\Structs\VoluntaryChangesType|null
     */
    public function getVoluntaryChanges()
    {
        return $this->VoluntaryChanges;
    }
    /**
     * Set VoluntaryChanges value
     * @param \Sabre\BargainFinderMax\Structs\VoluntaryChangesType $voluntaryChanges
     * @return \Sabre\BargainFinderMax\Structs\FareRestrictPref
     */
    public function setVoluntaryChanges(\Sabre\BargainFinderMax\Structs\VoluntaryChangesType $voluntaryChanges = null)
    {
        $this->VoluntaryChanges = $voluntaryChanges;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareRestrictPref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
