<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareOverride Structs
 * Meta informations extracted from the WSDL
 * - documentation: Contains attributes of the FareGroup functionality used during shopping and pricing. If passed in this request, it will override setting in the rule.
 * @subpackage Structs
 */
class FareOverride extends AbstractStructBase
{
    /**
     * The FareType
     * Meta informations extracted from the WSDL
     * - documentation: Attribute of FareGroup functionality, used in search of fares during shopping.
     * - use: required
     * @var string
     */
    public $FareType;
    /**
     * The VendorPref
     * Meta informations extracted from the WSDL
     * - documentation: Specify vendors to include and exclude from the response.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CompanyNamePrefType[]
     */
    public $VendorPref;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - documentation: This is a place holder for additional elements.
     * - minOccurs: 0
     * @var string
     */
    public $TPA_Extensions;
    /**
     * The PseudoCityCode
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The CorporateID
     * Meta informations extracted from the WSDL
     * - documentation: Attribute of FareGroup functionality, used in search of fares during shopping.
     * @var string
     */
    public $CorporateID;
    /**
     * The Callable
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Indicator to enable/disable this FareOverride.
     * - use: optional
     * @var string
     */
    public $Callable;
    /**
     * Constructor method for FareOverride
     * @uses FareOverride::setFareType()
     * @uses FareOverride::setVendorPref()
     * @uses FareOverride::setTPA_Extensions()
     * @uses FareOverride::setPseudoCityCode()
     * @uses FareOverride::setCorporateID()
     * @uses FareOverride::setCallable()
     * @param string $fareType
     * @param \Sabre\BargainFinderMax\Structs\CompanyNamePrefType[] $vendorPref
     * @param string $tPA_Extensions
     * @param string $pseudoCityCode
     * @param string $corporateID
     * @param string $callable
     */
    public function __construct($fareType = null, array $vendorPref = array(), $tPA_Extensions = null, $pseudoCityCode = null, $corporateID = null, $callable = 'true')
    {
        $this
            ->setFareType($fareType)
            ->setVendorPref($vendorPref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setPseudoCityCode($pseudoCityCode)
            ->setCorporateID($corporateID)
            ->setCallable($callable);
    }
    /**
     * Get FareType value
     * @return string
     */
    public function getFareType()
    {
        return $this->FareType;
    }
    /**
     * Set FareType value
     * @param string $fareType
     * @return \Sabre\BargainFinderMax\Structs\FareOverride
     */
    public function setFareType($fareType = null)
    {
        $this->FareType = $fareType;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \Sabre\BargainFinderMax\Structs\CompanyNamePrefType[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CompanyNamePrefType[] $vendorPref
     * @return \Sabre\BargainFinderMax\Structs\FareOverride
     */
    public function setVendorPref(array $vendorPref = array())
    {
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CompanyNamePrefType $item
     * @return \Sabre\BargainFinderMax\Structs\FareOverride
     */
    public function addToVendorPref(\Sabre\BargainFinderMax\Structs\CompanyNamePrefType $item)
    {
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return string|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param string $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\FareOverride
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\BargainFinderMax\Structs\FareOverride
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get CorporateID value
     * @return string|null
     */
    public function getCorporateID()
    {
        return $this->CorporateID;
    }
    /**
     * Set CorporateID value
     * @param string $corporateID
     * @return \Sabre\BargainFinderMax\Structs\FareOverride
     */
    public function setCorporateID($corporateID = null)
    {
        $this->CorporateID = $corporateID;
        return $this;
    }
    /**
     * Get Callable value
     * @return string|null
     */
    public function getCallable()
    {
        return $this->Callable;
    }
    /**
     * Set Callable value
     * @param string $callable
     * @return \Sabre\BargainFinderMax\Structs\FareOverride
     */
    public function setCallable($callable = 'true')
    {
        $this->Callable = $callable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareOverride
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
