<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareNote Structs
 * @subpackage Structs
 */
class FareNote extends AbstractStructBase
{
    /**
     * The FareTypeName
     * Meta informations extracted from the WSDL
     * - documentation: Corresponds to data in the Fare Note rule (action target: Fare Type). For example: "PROMOTIONAL"
     * - use: optional
     * @var string
     */
    public $FareTypeName;
    /**
     * The PriorityLevel
     * Meta informations extracted from the WSDL
     * - documentation: FareNote Itin priority
     * @var int
     */
    public $PriorityLevel;
    /**
     * The ContentID
     * Meta informations extracted from the WSDL
     * - documentation: Corresponds to data in the Fare Note rule (action target: Content ID Action). For example: "112"
     * @var string
     */
    public $ContentID;
    /**
     * Constructor method for FareNote
     * @uses FareNote::setFareTypeName()
     * @uses FareNote::setPriorityLevel()
     * @uses FareNote::setContentID()
     * @param string $fareTypeName
     * @param int $priorityLevel
     * @param string $contentID
     */
    public function __construct($fareTypeName = null, $priorityLevel = null, $contentID = null)
    {
        $this
            ->setFareTypeName($fareTypeName)
            ->setPriorityLevel($priorityLevel)
            ->setContentID($contentID);
    }
    /**
     * Get FareTypeName value
     * @return string|null
     */
    public function getFareTypeName()
    {
        return $this->FareTypeName;
    }
    /**
     * Set FareTypeName value
     * @param string $fareTypeName
     * @return \Sabre\BargainFinderMax\Structs\FareNote
     */
    public function setFareTypeName($fareTypeName = null)
    {
        $this->FareTypeName = $fareTypeName;
        return $this;
    }
    /**
     * Get PriorityLevel value
     * @return int|null
     */
    public function getPriorityLevel()
    {
        return $this->PriorityLevel;
    }
    /**
     * Set PriorityLevel value
     * @param int $priorityLevel
     * @return \Sabre\BargainFinderMax\Structs\FareNote
     */
    public function setPriorityLevel($priorityLevel = null)
    {
        $this->PriorityLevel = $priorityLevel;
        return $this;
    }
    /**
     * Get ContentID value
     * @return string|null
     */
    public function getContentID()
    {
        return $this->ContentID;
    }
    /**
     * Set ContentID value
     * @param string $contentID
     * @return \Sabre\BargainFinderMax\Structs\FareNote
     */
    public function setContentID($contentID = null)
    {
        $this->ContentID = $contentID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
