<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareInfoType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Rules for this priced option.
 * @subpackage Structs
 */
class FareInfoType extends AbstractStructBase
{
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - documentation: Departure Date for this priced fare.
     * - minOccurs: 0
     * @var string
     */
    public $DepartureDate;
    /**
     * The FareReference
     * Meta informations extracted from the WSDL
     * - documentation: FareReferenceCode can be used for either the Fare Basis Code or the Fare Class Code. | Used for Character Strings, length 1 to 8
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $FareReference;
    /**
     * The RuleInfo
     * Meta informations extracted from the WSDL
     * - documentation: Information regarding restrictions governing use of the fare.
     * @var \Sabre\BargainFinderMax\Structs\RuleInfoType
     */
    public $RuleInfo;
    /**
     * The MarketingAirline
     * Meta informations extracted from the WSDL
     * - documentation: The marketing airline.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CompanyNameType[]
     */
    public $MarketingAirline;
    /**
     * The DepartureAirport
     * Meta informations extracted from the WSDL
     * - documentation: Departure point of flight segment.
     * @var \Sabre\BargainFinderMax\Structs\ResponseLocationType
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta informations extracted from the WSDL
     * - documentation: Arrival point of flight segment.
     * @var \Sabre\BargainFinderMax\Structs\ResponseLocationType
     */
    public $ArrivalAirport;
    /**
     * The NegotiatedFare
     * Meta informations extracted from the WSDL
     * - documentation: Indicator to show if this is a private fare.
     * @var bool
     */
    public $NegotiatedFare;
    /**
     * The NegotiatedFareCode
     * Meta informations extracted from the WSDL
     * - documentation: Code used to identify the private fare.
     * @var string
     */
    public $NegotiatedFareCode;
    /**
     * Constructor method for FareInfoType
     * @uses FareInfoType::setDepartureDate()
     * @uses FareInfoType::setFareReference()
     * @uses FareInfoType::setRuleInfo()
     * @uses FareInfoType::setMarketingAirline()
     * @uses FareInfoType::setDepartureAirport()
     * @uses FareInfoType::setArrivalAirport()
     * @uses FareInfoType::setNegotiatedFare()
     * @uses FareInfoType::setNegotiatedFareCode()
     * @param string $departureDate
     * @param string $fareReference
     * @param \Sabre\BargainFinderMax\Structs\RuleInfoType $ruleInfo
     * @param \Sabre\BargainFinderMax\Structs\CompanyNameType[] $marketingAirline
     * @param \Sabre\BargainFinderMax\Structs\ResponseLocationType $departureAirport
     * @param \Sabre\BargainFinderMax\Structs\ResponseLocationType $arrivalAirport
     * @param bool $negotiatedFare
     * @param string $negotiatedFareCode
     */
    public function __construct($departureDate = null, $fareReference = null, \Sabre\BargainFinderMax\Structs\RuleInfoType $ruleInfo = null, array $marketingAirline = array(), \Sabre\BargainFinderMax\Structs\ResponseLocationType $departureAirport = null, \Sabre\BargainFinderMax\Structs\ResponseLocationType $arrivalAirport = null, $negotiatedFare = null, $negotiatedFareCode = null)
    {
        $this
            ->setDepartureDate($departureDate)
            ->setFareReference($fareReference)
            ->setRuleInfo($ruleInfo)
            ->setMarketingAirline($marketingAirline)
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setNegotiatedFare($negotiatedFare)
            ->setNegotiatedFareCode($negotiatedFareCode);
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \Sabre\BargainFinderMax\Structs\FareInfoType
     */
    public function setDepartureDate($departureDate = null)
    {
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get FareReference value
     * @return string|null
     */
    public function getFareReference()
    {
        return $this->FareReference;
    }
    /**
     * Set FareReference value
     * @param string $fareReference
     * @return \Sabre\BargainFinderMax\Structs\FareInfoType
     */
    public function setFareReference($fareReference = null)
    {
        $this->FareReference = $fareReference;
        return $this;
    }
    /**
     * Get RuleInfo value
     * @return \Sabre\BargainFinderMax\Structs\RuleInfoType|null
     */
    public function getRuleInfo()
    {
        return $this->RuleInfo;
    }
    /**
     * Set RuleInfo value
     * @param \Sabre\BargainFinderMax\Structs\RuleInfoType $ruleInfo
     * @return \Sabre\BargainFinderMax\Structs\FareInfoType
     */
    public function setRuleInfo(\Sabre\BargainFinderMax\Structs\RuleInfoType $ruleInfo = null)
    {
        $this->RuleInfo = $ruleInfo;
        return $this;
    }
    /**
     * Get MarketingAirline value
     * @return \Sabre\BargainFinderMax\Structs\CompanyNameType[]|null
     */
    public function getMarketingAirline()
    {
        return $this->MarketingAirline;
    }
    /**
     * Set MarketingAirline value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CompanyNameType[] $marketingAirline
     * @return \Sabre\BargainFinderMax\Structs\FareInfoType
     */
    public function setMarketingAirline(array $marketingAirline = array())
    {
        $this->MarketingAirline = $marketingAirline;
        return $this;
    }
    /**
     * Add item to MarketingAirline value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CompanyNameType $item
     * @return \Sabre\BargainFinderMax\Structs\FareInfoType
     */
    public function addToMarketingAirline(\Sabre\BargainFinderMax\Structs\CompanyNameType $item)
    {
        $this->MarketingAirline[] = $item;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return \Sabre\BargainFinderMax\Structs\ResponseLocationType|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \Sabre\BargainFinderMax\Structs\ResponseLocationType $departureAirport
     * @return \Sabre\BargainFinderMax\Structs\FareInfoType
     */
    public function setDepartureAirport(\Sabre\BargainFinderMax\Structs\ResponseLocationType $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return \Sabre\BargainFinderMax\Structs\ResponseLocationType|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \Sabre\BargainFinderMax\Structs\ResponseLocationType $arrivalAirport
     * @return \Sabre\BargainFinderMax\Structs\FareInfoType
     */
    public function setArrivalAirport(\Sabre\BargainFinderMax\Structs\ResponseLocationType $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get NegotiatedFare value
     * @return bool|null
     */
    public function getNegotiatedFare()
    {
        return $this->NegotiatedFare;
    }
    /**
     * Set NegotiatedFare value
     * @param bool $negotiatedFare
     * @return \Sabre\BargainFinderMax\Structs\FareInfoType
     */
    public function setNegotiatedFare($negotiatedFare = null)
    {
        $this->NegotiatedFare = $negotiatedFare;
        return $this;
    }
    /**
     * Get NegotiatedFareCode value
     * @return string|null
     */
    public function getNegotiatedFareCode()
    {
        return $this->NegotiatedFareCode;
    }
    /**
     * Set NegotiatedFareCode value
     * @param string $negotiatedFareCode
     * @return \Sabre\BargainFinderMax\Structs\FareInfoType
     */
    public function setNegotiatedFareCode($negotiatedFareCode = null)
    {
        $this->NegotiatedFareCode = $negotiatedFareCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
