<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareComponentType Structs
 * @subpackage Structs
 */
class FareComponentType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Fare component ID
     * - use: required
     * @var int
     */
    public $ID;
    /**
     * The GoverningCarrier
     * Meta informations extracted from the WSDL
     * - documentation: Governing carrier code | Airline carrier code type
     * - use: required
     * - pattern: \*\*
     * @var string
     */
    public $GoverningCarrier;
    /**
     * The FareAmount
     * Meta informations extracted from the WSDL
     * - documentation: Fare amount
     * - use: required
     * @var float
     */
    public $FareAmount;
    /**
     * The FareBasisCode
     * Meta informations extracted from the WSDL
     * - documentation: Fare basis code
     * - use: required
     * @var string
     */
    public $FareBasisCode;
    /**
     * The FarePassengerType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $FarePassengerType;
    /**
     * The Segment
     * Meta informations extracted from the WSDL
     * - documentation: Fare segment information
     * @var \Sabre\BargainFinderMax\Structs\FareSegmentType
     */
    public $Segment;
    /**
     * The Surface
     * Meta informations extracted from the WSDL
     * - documentation: Surface segment (Arunk)
     * @var \Sabre\BargainFinderMax\Structs\SurfaceType
     */
    public $Surface;
    /**
     * The Brand
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\BrandType
     */
    public $Brand;
    /**
     * The HigherIntermediatePoint
     * Meta informations extracted from the WSDL
     * - documentation: Higher Intermediate Point differential information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType[]
     */
    public $HigherIntermediatePoint;
    /**
     * The PlusUp
     * Meta informations extracted from the WSDL
     * - documentation: Plus Up information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PlusUpInformationType[]
     */
    public $PlusUp;
    /**
     * The HandlingMarkupDetail
     * Meta informations extracted from the WSDL
     * - documentation: Handling Markup Detail
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\HandlingMarkupDetailType[]
     */
    public $HandlingMarkupDetail;
    /**
     * The FareCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Fare component currency code | Currency Code type
     * - use: required | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $FareCurrency;
    /**
     * The TicketDesignator
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TicketDesignator;
    /**
     * The PublishedFareAmount
     * Meta informations extracted from the WSDL
     * - documentation: Published fare amount
     * - use: optional
     * @var float
     */
    public $PublishedFareAmount;
    /**
     * The MileageSurcharge
     * Meta informations extracted from the WSDL
     * - documentation: Mileage surcharge percentage
     * - use: optional
     * @var int
     */
    public $MileageSurcharge;
    /**
     * The Mileage
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Is Mileage Routing
     * - use: optional
     * @var bool
     */
    public $Mileage;
    /**
     * The CorporateIdMatched
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Fare Match CorpID
     * - use: optional
     * @var bool
     */
    public $CorporateIdMatched;
    /**
     * The OneWayFare
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: One way fare
     * - use: optional
     * @var bool
     */
    public $OneWayFare;
    /**
     * The WebBasedFare
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Web based fare
     * - use: optional
     * @var bool
     */
    public $WebBasedFare;
    /**
     * The NegotiatedFare
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Negotiated fare
     * - use: optional
     * @var bool
     */
    public $NegotiatedFare;
    /**
     * The PrivateFare
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Private fare
     * - use: optional
     * @var bool
     */
    public $PrivateFare;
    /**
     * The MatchedAccountCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MatchedAccountCode;
    /**
     * The Directionality
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Directionality;
    /**
     * The MilesAmount
     * Meta informations extracted from the WSDL
     * - documentation: Amount of miles (AWARD shopping)
     * @var int
     */
    public $MilesAmount;
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - documentation: Global Direction indicator
     * - use: optional
     * @var string
     */
    public $Direction;
    /**
     * The NotValidBefore
     * Meta informations extracted from the WSDL
     * - documentation: Not valid before date
     * - use: optional
     * @var string
     */
    public $NotValidBefore;
    /**
     * The NotValidAfter
     * Meta informations extracted from the WSDL
     * - documentation: Not valid after date
     * - use: optional
     * @var string
     */
    public $NotValidAfter;
    /**
     * The ApplicablePricingCategories
     * @var string
     */
    public $ApplicablePricingCategories;
    /**
     * The FareComponentReferenceID
     * Meta informations extracted from the WSDL
     * - documentation: Fare component number
     * - use: optional
     * @var int
     */
    public $FareComponentReferenceID;
    /**
     * The GeneralRetailerRuleCode
     * Meta informations extracted from the WSDL
     * - documentation: Matched General Retailer Rule Qualifier Code
     * - use: optional
     * - pattern: [0-9A-Za-z]{2,20}
     * @var string
     */
    public $GeneralRetailerRuleCode;
    /**
     * The AslRetailerRuleCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AslRetailerRuleCode;
    /**
     * The VendorCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $VendorCode;
    /**
     * Constructor method for FareComponentType
     * @uses FareComponentType::setID()
     * @uses FareComponentType::setGoverningCarrier()
     * @uses FareComponentType::setFareAmount()
     * @uses FareComponentType::setFareBasisCode()
     * @uses FareComponentType::setFarePassengerType()
     * @uses FareComponentType::setSegment()
     * @uses FareComponentType::setSurface()
     * @uses FareComponentType::setBrand()
     * @uses FareComponentType::setHigherIntermediatePoint()
     * @uses FareComponentType::setPlusUp()
     * @uses FareComponentType::setHandlingMarkupDetail()
     * @uses FareComponentType::setFareCurrency()
     * @uses FareComponentType::setTicketDesignator()
     * @uses FareComponentType::setPublishedFareAmount()
     * @uses FareComponentType::setMileageSurcharge()
     * @uses FareComponentType::setMileage()
     * @uses FareComponentType::setCorporateIdMatched()
     * @uses FareComponentType::setOneWayFare()
     * @uses FareComponentType::setWebBasedFare()
     * @uses FareComponentType::setNegotiatedFare()
     * @uses FareComponentType::setPrivateFare()
     * @uses FareComponentType::setMatchedAccountCode()
     * @uses FareComponentType::setDirectionality()
     * @uses FareComponentType::setMilesAmount()
     * @uses FareComponentType::setDirection()
     * @uses FareComponentType::setNotValidBefore()
     * @uses FareComponentType::setNotValidAfter()
     * @uses FareComponentType::setApplicablePricingCategories()
     * @uses FareComponentType::setFareComponentReferenceID()
     * @uses FareComponentType::setGeneralRetailerRuleCode()
     * @uses FareComponentType::setAslRetailerRuleCode()
     * @uses FareComponentType::setVendorCode()
     * @param int $iD
     * @param string $governingCarrier
     * @param float $fareAmount
     * @param string $fareBasisCode
     * @param string $farePassengerType
     * @param \Sabre\BargainFinderMax\Structs\FareSegmentType $segment
     * @param \Sabre\BargainFinderMax\Structs\SurfaceType $surface
     * @param \Sabre\BargainFinderMax\Structs\BrandType $brand
     * @param \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType[] $higherIntermediatePoint
     * @param \Sabre\BargainFinderMax\Structs\PlusUpInformationType[] $plusUp
     * @param \Sabre\BargainFinderMax\Structs\HandlingMarkupDetailType[] $handlingMarkupDetail
     * @param string $fareCurrency
     * @param string $ticketDesignator
     * @param float $publishedFareAmount
     * @param int $mileageSurcharge
     * @param bool $mileage
     * @param bool $corporateIdMatched
     * @param bool $oneWayFare
     * @param bool $webBasedFare
     * @param bool $negotiatedFare
     * @param bool $privateFare
     * @param string $matchedAccountCode
     * @param string $directionality
     * @param int $milesAmount
     * @param string $direction
     * @param string $notValidBefore
     * @param string $notValidAfter
     * @param string $applicablePricingCategories
     * @param int $fareComponentReferenceID
     * @param string $generalRetailerRuleCode
     * @param string $aslRetailerRuleCode
     * @param string $vendorCode
     */
    public function __construct($iD = null, $governingCarrier = null, $fareAmount = null, $fareBasisCode = null, $farePassengerType = null, \Sabre\BargainFinderMax\Structs\FareSegmentType $segment = null, \Sabre\BargainFinderMax\Structs\SurfaceType $surface = null, \Sabre\BargainFinderMax\Structs\BrandType $brand = null, array $higherIntermediatePoint = array(), array $plusUp = array(), array $handlingMarkupDetail = array(), $fareCurrency = null, $ticketDesignator = null, $publishedFareAmount = null, $mileageSurcharge = null, $mileage = false, $corporateIdMatched = false, $oneWayFare = false, $webBasedFare = false, $negotiatedFare = false, $privateFare = false, $matchedAccountCode = null, $directionality = null, $milesAmount = null, $direction = null, $notValidBefore = null, $notValidAfter = null, $applicablePricingCategories = null, $fareComponentReferenceID = null, $generalRetailerRuleCode = null, $aslRetailerRuleCode = null, $vendorCode = null)
    {
        $this
            ->setID($iD)
            ->setGoverningCarrier($governingCarrier)
            ->setFareAmount($fareAmount)
            ->setFareBasisCode($fareBasisCode)
            ->setFarePassengerType($farePassengerType)
            ->setSegment($segment)
            ->setSurface($surface)
            ->setBrand($brand)
            ->setHigherIntermediatePoint($higherIntermediatePoint)
            ->setPlusUp($plusUp)
            ->setHandlingMarkupDetail($handlingMarkupDetail)
            ->setFareCurrency($fareCurrency)
            ->setTicketDesignator($ticketDesignator)
            ->setPublishedFareAmount($publishedFareAmount)
            ->setMileageSurcharge($mileageSurcharge)
            ->setMileage($mileage)
            ->setCorporateIdMatched($corporateIdMatched)
            ->setOneWayFare($oneWayFare)
            ->setWebBasedFare($webBasedFare)
            ->setNegotiatedFare($negotiatedFare)
            ->setPrivateFare($privateFare)
            ->setMatchedAccountCode($matchedAccountCode)
            ->setDirectionality($directionality)
            ->setMilesAmount($milesAmount)
            ->setDirection($direction)
            ->setNotValidBefore($notValidBefore)
            ->setNotValidAfter($notValidAfter)
            ->setApplicablePricingCategories($applicablePricingCategories)
            ->setFareComponentReferenceID($fareComponentReferenceID)
            ->setGeneralRetailerRuleCode($generalRetailerRuleCode)
            ->setAslRetailerRuleCode($aslRetailerRuleCode)
            ->setVendorCode($vendorCode);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get GoverningCarrier value
     * @return string
     */
    public function getGoverningCarrier()
    {
        return $this->GoverningCarrier;
    }
    /**
     * Set GoverningCarrier value
     * @param string $governingCarrier
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setGoverningCarrier($governingCarrier = null)
    {
        $this->GoverningCarrier = $governingCarrier;
        return $this;
    }
    /**
     * Get FareAmount value
     * @return float
     */
    public function getFareAmount()
    {
        return $this->FareAmount;
    }
    /**
     * Set FareAmount value
     * @param float $fareAmount
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setFareAmount($fareAmount = null)
    {
        $this->FareAmount = $fareAmount;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get FarePassengerType value
     * @return string
     */
    public function getFarePassengerType()
    {
        return $this->FarePassengerType;
    }
    /**
     * Set FarePassengerType value
     * @param string $farePassengerType
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setFarePassengerType($farePassengerType = null)
    {
        $this->FarePassengerType = $farePassengerType;
        return $this;
    }
    /**
     * Get Segment value
     * @return \Sabre\BargainFinderMax\Structs\FareSegmentType|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @param \Sabre\BargainFinderMax\Structs\FareSegmentType $segment
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setSegment(\Sabre\BargainFinderMax\Structs\FareSegmentType $segment = null)
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Get Surface value
     * @return \Sabre\BargainFinderMax\Structs\SurfaceType|null
     */
    public function getSurface()
    {
        return $this->Surface;
    }
    /**
     * Set Surface value
     * @param \Sabre\BargainFinderMax\Structs\SurfaceType $surface
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setSurface(\Sabre\BargainFinderMax\Structs\SurfaceType $surface = null)
    {
        $this->Surface = $surface;
        return $this;
    }
    /**
     * Get Brand value
     * @return \Sabre\BargainFinderMax\Structs\BrandType|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param \Sabre\BargainFinderMax\Structs\BrandType $brand
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setBrand(\Sabre\BargainFinderMax\Structs\BrandType $brand = null)
    {
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Get HigherIntermediatePoint value
     * @return \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType[]|null
     */
    public function getHigherIntermediatePoint()
    {
        return $this->HigherIntermediatePoint;
    }
    /**
     * Set HigherIntermediatePoint value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType[] $higherIntermediatePoint
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setHigherIntermediatePoint(array $higherIntermediatePoint = array())
    {
        $this->HigherIntermediatePoint = $higherIntermediatePoint;
        return $this;
    }
    /**
     * Add item to HigherIntermediatePoint value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\HigherIntermediatePointType $item
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function addToHigherIntermediatePoint(\Sabre\BargainFinderMax\Structs\HigherIntermediatePointType $item)
    {
        $this->HigherIntermediatePoint[] = $item;
        return $this;
    }
    /**
     * Get PlusUp value
     * @return \Sabre\BargainFinderMax\Structs\PlusUpInformationType[]|null
     */
    public function getPlusUp()
    {
        return $this->PlusUp;
    }
    /**
     * Set PlusUp value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PlusUpInformationType[] $plusUp
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setPlusUp(array $plusUp = array())
    {
        $this->PlusUp = $plusUp;
        return $this;
    }
    /**
     * Add item to PlusUp value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PlusUpInformationType $item
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function addToPlusUp(\Sabre\BargainFinderMax\Structs\PlusUpInformationType $item)
    {
        $this->PlusUp[] = $item;
        return $this;
    }
    /**
     * Get HandlingMarkupDetail value
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupDetailType[]|null
     */
    public function getHandlingMarkupDetail()
    {
        return $this->HandlingMarkupDetail;
    }
    /**
     * Set HandlingMarkupDetail value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\HandlingMarkupDetailType[] $handlingMarkupDetail
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setHandlingMarkupDetail(array $handlingMarkupDetail = array())
    {
        $this->HandlingMarkupDetail = $handlingMarkupDetail;
        return $this;
    }
    /**
     * Add item to HandlingMarkupDetail value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\HandlingMarkupDetailType $item
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function addToHandlingMarkupDetail(\Sabre\BargainFinderMax\Structs\HandlingMarkupDetailType $item)
    {
        $this->HandlingMarkupDetail[] = $item;
        return $this;
    }
    /**
     * Get FareCurrency value
     * @return string|null
     */
    public function getFareCurrency()
    {
        return $this->FareCurrency;
    }
    /**
     * Set FareCurrency value
     * @param string $fareCurrency
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setFareCurrency($fareCurrency = null)
    {
        $this->FareCurrency = $fareCurrency;
        return $this;
    }
    /**
     * Get TicketDesignator value
     * @return string|null
     */
    public function getTicketDesignator()
    {
        return $this->TicketDesignator;
    }
    /**
     * Set TicketDesignator value
     * @param string $ticketDesignator
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setTicketDesignator($ticketDesignator = null)
    {
        $this->TicketDesignator = $ticketDesignator;
        return $this;
    }
    /**
     * Get PublishedFareAmount value
     * @return float|null
     */
    public function getPublishedFareAmount()
    {
        return $this->PublishedFareAmount;
    }
    /**
     * Set PublishedFareAmount value
     * @param float $publishedFareAmount
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setPublishedFareAmount($publishedFareAmount = null)
    {
        $this->PublishedFareAmount = $publishedFareAmount;
        return $this;
    }
    /**
     * Get MileageSurcharge value
     * @return int|null
     */
    public function getMileageSurcharge()
    {
        return $this->MileageSurcharge;
    }
    /**
     * Set MileageSurcharge value
     * @param int $mileageSurcharge
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setMileageSurcharge($mileageSurcharge = null)
    {
        $this->MileageSurcharge = $mileageSurcharge;
        return $this;
    }
    /**
     * Get Mileage value
     * @return bool|null
     */
    public function getMileage()
    {
        return $this->Mileage;
    }
    /**
     * Set Mileage value
     * @param bool $mileage
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setMileage($mileage = false)
    {
        $this->Mileage = $mileage;
        return $this;
    }
    /**
     * Get CorporateIdMatched value
     * @return bool|null
     */
    public function getCorporateIdMatched()
    {
        return $this->CorporateIdMatched;
    }
    /**
     * Set CorporateIdMatched value
     * @param bool $corporateIdMatched
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setCorporateIdMatched($corporateIdMatched = false)
    {
        $this->CorporateIdMatched = $corporateIdMatched;
        return $this;
    }
    /**
     * Get OneWayFare value
     * @return bool|null
     */
    public function getOneWayFare()
    {
        return $this->OneWayFare;
    }
    /**
     * Set OneWayFare value
     * @param bool $oneWayFare
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setOneWayFare($oneWayFare = false)
    {
        $this->OneWayFare = $oneWayFare;
        return $this;
    }
    /**
     * Get WebBasedFare value
     * @return bool|null
     */
    public function getWebBasedFare()
    {
        return $this->WebBasedFare;
    }
    /**
     * Set WebBasedFare value
     * @param bool $webBasedFare
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setWebBasedFare($webBasedFare = false)
    {
        $this->WebBasedFare = $webBasedFare;
        return $this;
    }
    /**
     * Get NegotiatedFare value
     * @return bool|null
     */
    public function getNegotiatedFare()
    {
        return $this->NegotiatedFare;
    }
    /**
     * Set NegotiatedFare value
     * @param bool $negotiatedFare
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setNegotiatedFare($negotiatedFare = false)
    {
        $this->NegotiatedFare = $negotiatedFare;
        return $this;
    }
    /**
     * Get PrivateFare value
     * @return bool|null
     */
    public function getPrivateFare()
    {
        return $this->PrivateFare;
    }
    /**
     * Set PrivateFare value
     * @param bool $privateFare
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setPrivateFare($privateFare = false)
    {
        $this->PrivateFare = $privateFare;
        return $this;
    }
    /**
     * Get MatchedAccountCode value
     * @return string|null
     */
    public function getMatchedAccountCode()
    {
        return $this->MatchedAccountCode;
    }
    /**
     * Set MatchedAccountCode value
     * @param string $matchedAccountCode
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setMatchedAccountCode($matchedAccountCode = null)
    {
        $this->MatchedAccountCode = $matchedAccountCode;
        return $this;
    }
    /**
     * Get Directionality value
     * @return string|null
     */
    public function getDirectionality()
    {
        return $this->Directionality;
    }
    /**
     * Set Directionality value
     * @param string $directionality
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setDirectionality($directionality = null)
    {
        $this->Directionality = $directionality;
        return $this;
    }
    /**
     * Get MilesAmount value
     * @return int|null
     */
    public function getMilesAmount()
    {
        return $this->MilesAmount;
    }
    /**
     * Set MilesAmount value
     * @param int $milesAmount
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setMilesAmount($milesAmount = null)
    {
        $this->MilesAmount = $milesAmount;
        return $this;
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @uses \Sabre\BargainFinderMax\Enums\GlobalDirection::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\GlobalDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setDirection($direction = null)
    {
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get NotValidBefore value
     * @return string|null
     */
    public function getNotValidBefore()
    {
        return $this->NotValidBefore;
    }
    /**
     * Set NotValidBefore value
     * @param string $notValidBefore
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setNotValidBefore($notValidBefore = null)
    {
        $this->NotValidBefore = $notValidBefore;
        return $this;
    }
    /**
     * Get NotValidAfter value
     * @return string|null
     */
    public function getNotValidAfter()
    {
        return $this->NotValidAfter;
    }
    /**
     * Set NotValidAfter value
     * @param string $notValidAfter
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setNotValidAfter($notValidAfter = null)
    {
        $this->NotValidAfter = $notValidAfter;
        return $this;
    }
    /**
     * Get ApplicablePricingCategories value
     * @return string|null
     */
    public function getApplicablePricingCategories()
    {
        return $this->ApplicablePricingCategories;
    }
    /**
     * Set ApplicablePricingCategories value
     * @param string $applicablePricingCategories
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setApplicablePricingCategories($applicablePricingCategories = null)
    {
        $this->ApplicablePricingCategories = $applicablePricingCategories;
        return $this;
    }
    /**
     * Get FareComponentReferenceID value
     * @return int|null
     */
    public function getFareComponentReferenceID()
    {
        return $this->FareComponentReferenceID;
    }
    /**
     * Set FareComponentReferenceID value
     * @param int $fareComponentReferenceID
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setFareComponentReferenceID($fareComponentReferenceID = null)
    {
        $this->FareComponentReferenceID = $fareComponentReferenceID;
        return $this;
    }
    /**
     * Get GeneralRetailerRuleCode value
     * @return string|null
     */
    public function getGeneralRetailerRuleCode()
    {
        return $this->GeneralRetailerRuleCode;
    }
    /**
     * Set GeneralRetailerRuleCode value
     * @param string $generalRetailerRuleCode
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setGeneralRetailerRuleCode($generalRetailerRuleCode = null)
    {
        $this->GeneralRetailerRuleCode = $generalRetailerRuleCode;
        return $this;
    }
    /**
     * Get AslRetailerRuleCode value
     * @return string|null
     */
    public function getAslRetailerRuleCode()
    {
        return $this->AslRetailerRuleCode;
    }
    /**
     * Set AslRetailerRuleCode value
     * @param string $aslRetailerRuleCode
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setAslRetailerRuleCode($aslRetailerRuleCode = null)
    {
        $this->AslRetailerRuleCode = $aslRetailerRuleCode;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public function setVendorCode($vendorCode = null)
    {
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareComponentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
