<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareComponentTaxesType Structs
 * @subpackage Structs
 */
class FareComponentTaxesType extends AbstractStructBase
{
    /**
     * The FlightSegment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\FlightSegment[]
     */
    public $FlightSegment;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - documentation: Any individual tax applied to the fare
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AirTaxType[]
     */
    public $Tax;
    /**
     * The TaxSummary
     * Meta informations extracted from the WSDL
     * - documentation: Tax Summary Information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AirTaxSummaryType[]
     */
    public $TaxSummary;
    /**
     * Constructor method for FareComponentTaxesType
     * @uses FareComponentTaxesType::setFlightSegment()
     * @uses FareComponentTaxesType::setTax()
     * @uses FareComponentTaxesType::setTaxSummary()
     * @param \Sabre\BargainFinderMax\Structs\FlightSegment[] $flightSegment
     * @param \Sabre\BargainFinderMax\Structs\AirTaxType[] $tax
     * @param \Sabre\BargainFinderMax\Structs\AirTaxSummaryType[] $taxSummary
     */
    public function __construct(array $flightSegment = array(), array $tax = array(), array $taxSummary = array())
    {
        $this
            ->setFlightSegment($flightSegment)
            ->setTax($tax)
            ->setTaxSummary($taxSummary);
    }
    /**
     * Get FlightSegment value
     * @return \Sabre\BargainFinderMax\Structs\FlightSegment[]|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FlightSegment[] $flightSegment
     * @return \Sabre\BargainFinderMax\Structs\FareComponentTaxesType
     */
    public function setFlightSegment(array $flightSegment = array())
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Add item to FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FlightSegment $item
     * @return \Sabre\BargainFinderMax\Structs\FareComponentTaxesType
     */
    public function addToFlightSegment(\Sabre\BargainFinderMax\Structs\FlightSegment $item)
    {
        $this->FlightSegment[] = $item;
        return $this;
    }
    /**
     * Get Tax value
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirTaxType[] $tax
     * @return \Sabre\BargainFinderMax\Structs\FareComponentTaxesType
     */
    public function setTax(array $tax = array())
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirTaxType $item
     * @return \Sabre\BargainFinderMax\Structs\FareComponentTaxesType
     */
    public function addToTax(\Sabre\BargainFinderMax\Structs\AirTaxType $item)
    {
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get TaxSummary value
     * @return \Sabre\BargainFinderMax\Structs\AirTaxSummaryType[]|null
     */
    public function getTaxSummary()
    {
        return $this->TaxSummary;
    }
    /**
     * Set TaxSummary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirTaxSummaryType[] $taxSummary
     * @return \Sabre\BargainFinderMax\Structs\FareComponentTaxesType
     */
    public function setTaxSummary(array $taxSummary = array())
    {
        $this->TaxSummary = $taxSummary;
        return $this;
    }
    /**
     * Add item to TaxSummary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirTaxSummaryType $item
     * @return \Sabre\BargainFinderMax\Structs\FareComponentTaxesType
     */
    public function addToTaxSummary(\Sabre\BargainFinderMax\Structs\AirTaxSummaryType $item)
    {
        $this->TaxSummary[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareComponentTaxesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
