<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Failed Structs
 * Meta informations extracted from the WSDL
 * - documentation: Information on problems that occurred while processing this itinerary.
 * @subpackage Structs
 */
class Failed extends AbstractStructBase
{
    /**
     * The MinimumConnectTime
     * Meta informations extracted from the WSDL
     * - documentation: Indicates that the itinerary does not fullfill the Minimum Connect Time requirement. It cannot be sold.
     * @var bool
     */
    public $MinimumConnectTime;
    /**
     * Constructor method for Failed
     * @uses Failed::setMinimumConnectTime()
     * @param bool $minimumConnectTime
     */
    public function __construct($minimumConnectTime = null)
    {
        $this
            ->setMinimumConnectTime($minimumConnectTime);
    }
    /**
     * Get MinimumConnectTime value
     * @return bool|null
     */
    public function getMinimumConnectTime()
    {
        return $this->MinimumConnectTime;
    }
    /**
     * Set MinimumConnectTime value
     * @param bool $minimumConnectTime
     * @return \Sabre\BargainFinderMax\Structs\Failed
     */
    public function setMinimumConnectTime($minimumConnectTime = null)
    {
        $this->MinimumConnectTime = $minimumConnectTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Failed
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
