<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeFareType Structs
 * @subpackage Structs
 */
class ExchangeFareType extends AbstractStructBase
{
    /**
     * The BaseFareAmount
     * Meta informations extracted from the WSDL
     * - documentation: Base fare amount | Used for amounts, max 3 decimals
     * - fractionDigits: 3
     * @var float
     */
    public $BaseFareAmount;
    /**
     * The NonRefundableAmount
     * Meta informations extracted from the WSDL
     * - documentation: Non-refundable Base Fare Amount. Currency is defined by @BaseFareCurrency. | Used for amounts, max 3 decimals
     * - fractionDigits: 3
     * @var float
     */
    public $NonRefundableAmount;
    /**
     * The BaseFareCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Base fare currency | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $BaseFareCurrency;
    /**
     * The FareCalcCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Fare calc currency | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $FareCalcCurrency;
    /**
     * The ValidatingCarrier
     * Meta informations extracted from the WSDL
     * - documentation: Validating carrier
     * - pattern: [0-9A-Z]{2,3}
     * @var string
     */
    public $ValidatingCarrier;
    /**
     * The ROE
     * Meta informations extracted from the WSDL
     * - documentation: Rate of Exchange override (note: doesn't need to be specified if FareCalc currency and BaseFare currency is the same).
     * @var float
     */
    public $ROE;
    /**
     * Constructor method for ExchangeFareType
     * @uses ExchangeFareType::setBaseFareAmount()
     * @uses ExchangeFareType::setNonRefundableAmount()
     * @uses ExchangeFareType::setBaseFareCurrency()
     * @uses ExchangeFareType::setFareCalcCurrency()
     * @uses ExchangeFareType::setValidatingCarrier()
     * @uses ExchangeFareType::setROE()
     * @param float $baseFareAmount
     * @param float $nonRefundableAmount
     * @param string $baseFareCurrency
     * @param string $fareCalcCurrency
     * @param string $validatingCarrier
     * @param float $rOE
     */
    public function __construct($baseFareAmount = null, $nonRefundableAmount = null, $baseFareCurrency = null, $fareCalcCurrency = null, $validatingCarrier = null, $rOE = null)
    {
        $this
            ->setBaseFareAmount($baseFareAmount)
            ->setNonRefundableAmount($nonRefundableAmount)
            ->setBaseFareCurrency($baseFareCurrency)
            ->setFareCalcCurrency($fareCalcCurrency)
            ->setValidatingCarrier($validatingCarrier)
            ->setROE($rOE);
    }
    /**
     * Get BaseFareAmount value
     * @return float|null
     */
    public function getBaseFareAmount()
    {
        return $this->BaseFareAmount;
    }
    /**
     * Set BaseFareAmount value
     * @param float $baseFareAmount
     * @return \Sabre\BargainFinderMax\Structs\ExchangeFareType
     */
    public function setBaseFareAmount($baseFareAmount = null)
    {
        $this->BaseFareAmount = $baseFareAmount;
        return $this;
    }
    /**
     * Get NonRefundableAmount value
     * @return float|null
     */
    public function getNonRefundableAmount()
    {
        return $this->NonRefundableAmount;
    }
    /**
     * Set NonRefundableAmount value
     * @param float $nonRefundableAmount
     * @return \Sabre\BargainFinderMax\Structs\ExchangeFareType
     */
    public function setNonRefundableAmount($nonRefundableAmount = null)
    {
        $this->NonRefundableAmount = $nonRefundableAmount;
        return $this;
    }
    /**
     * Get BaseFareCurrency value
     * @return string|null
     */
    public function getBaseFareCurrency()
    {
        return $this->BaseFareCurrency;
    }
    /**
     * Set BaseFareCurrency value
     * @param string $baseFareCurrency
     * @return \Sabre\BargainFinderMax\Structs\ExchangeFareType
     */
    public function setBaseFareCurrency($baseFareCurrency = null)
    {
        $this->BaseFareCurrency = $baseFareCurrency;
        return $this;
    }
    /**
     * Get FareCalcCurrency value
     * @return string|null
     */
    public function getFareCalcCurrency()
    {
        return $this->FareCalcCurrency;
    }
    /**
     * Set FareCalcCurrency value
     * @param string $fareCalcCurrency
     * @return \Sabre\BargainFinderMax\Structs\ExchangeFareType
     */
    public function setFareCalcCurrency($fareCalcCurrency = null)
    {
        $this->FareCalcCurrency = $fareCalcCurrency;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return string|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param string $validatingCarrier
     * @return \Sabre\BargainFinderMax\Structs\ExchangeFareType
     */
    public function setValidatingCarrier($validatingCarrier = null)
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
    /**
     * Get ROE value
     * @return float|null
     */
    public function getROE()
    {
        return $this->ROE;
    }
    /**
     * Set ROE value
     * @param float $rOE
     * @return \Sabre\BargainFinderMax\Structs\ExchangeFareType
     */
    public function setROE($rOE = null)
    {
        $this->ROE = $rOE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ExchangeFareType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
