<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Endorsements Structs
 * Meta informations extracted from the WSDL
 * - documentation: Container for endorsements.
 * @subpackage Structs
 */
class Endorsements extends AbstractStructBase
{
    /**
     * The Endorsement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Endorsement[]
     */
    public $Endorsement;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TPA_Extensions;
    /**
     * The NonRefundableIndicator
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the ticket is refundable. If true, the ticket is NOT refundable.
     * - use: optional
     * @var bool
     */
    public $NonRefundableIndicator;
    /**
     * The NonEndorsableIndicator
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the ticket is endorsable. If true, the ticket is NOT endorsable.
     * - use: optional
     * @var bool
     */
    public $NonEndorsableIndicator;
    /**
     * Constructor method for Endorsements
     * @uses Endorsements::setEndorsement()
     * @uses Endorsements::setTPA_Extensions()
     * @uses Endorsements::setNonRefundableIndicator()
     * @uses Endorsements::setNonEndorsableIndicator()
     * @param \Sabre\BargainFinderMax\Structs\Endorsement[] $endorsement
     * @param string $tPA_Extensions
     * @param bool $nonRefundableIndicator
     * @param bool $nonEndorsableIndicator
     */
    public function __construct(array $endorsement = array(), $tPA_Extensions = null, $nonRefundableIndicator = null, $nonEndorsableIndicator = null)
    {
        $this
            ->setEndorsement($endorsement)
            ->setTPA_Extensions($tPA_Extensions)
            ->setNonRefundableIndicator($nonRefundableIndicator)
            ->setNonEndorsableIndicator($nonEndorsableIndicator);
    }
    /**
     * Get Endorsement value
     * @return \Sabre\BargainFinderMax\Structs\Endorsement[]|null
     */
    public function getEndorsement()
    {
        return $this->Endorsement;
    }
    /**
     * Set Endorsement value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Endorsement[] $endorsement
     * @return \Sabre\BargainFinderMax\Structs\Endorsements
     */
    public function setEndorsement(array $endorsement = array())
    {
        $this->Endorsement = $endorsement;
        return $this;
    }
    /**
     * Add item to Endorsement value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Endorsement $item
     * @return \Sabre\BargainFinderMax\Structs\Endorsements
     */
    public function addToEndorsement(\Sabre\BargainFinderMax\Structs\Endorsement $item)
    {
        $this->Endorsement[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return string|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param string $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\Endorsements
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get NonRefundableIndicator value
     * @return bool|null
     */
    public function getNonRefundableIndicator()
    {
        return $this->NonRefundableIndicator;
    }
    /**
     * Set NonRefundableIndicator value
     * @param bool $nonRefundableIndicator
     * @return \Sabre\BargainFinderMax\Structs\Endorsements
     */
    public function setNonRefundableIndicator($nonRefundableIndicator = null)
    {
        $this->NonRefundableIndicator = $nonRefundableIndicator;
        return $this;
    }
    /**
     * Get NonEndorsableIndicator value
     * @return bool|null
     */
    public function getNonEndorsableIndicator()
    {
        return $this->NonEndorsableIndicator;
    }
    /**
     * Set NonEndorsableIndicator value
     * @param bool $nonEndorsableIndicator
     * @return \Sabre\BargainFinderMax\Structs\Endorsements
     */
    public function setNonEndorsableIndicator($nonEndorsableIndicator = null)
    {
        $this->NonEndorsableIndicator = $nonEndorsableIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Endorsements
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
