<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiversityParameters Structs
 * @subpackage Structs
 */
class DiversityParameters extends AbstractStructBase
{
    /**
     * The Weightings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Weightings
     */
    public $Weightings;
    /**
     * The TimeOfDayDistribution
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TimeOfDayDistribution
     */
    public $TimeOfDayDistribution;
    /**
     * The InboundOutboundPairing
     * @var string
     */
    public $InboundOutboundPairing;
    /**
     * The AdditionalNonStopsNumber
     * @var string
     */
    public $AdditionalNonStopsNumber;
    /**
     * The AdditionalNonStopsPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Defines how many additional non-stop options should be added to the response as a percentage of the requested number of options.
     * - maxInclusive: 100
     * - minInclusive: 0
     * @var int
     */
    public $AdditionalNonStopsPercentage;
    /**
     * Constructor method for DiversityParameters
     * @uses DiversityParameters::setWeightings()
     * @uses DiversityParameters::setTimeOfDayDistribution()
     * @uses DiversityParameters::setInboundOutboundPairing()
     * @uses DiversityParameters::setAdditionalNonStopsNumber()
     * @uses DiversityParameters::setAdditionalNonStopsPercentage()
     * @param \Sabre\BargainFinderMax\Structs\Weightings $weightings
     * @param \Sabre\BargainFinderMax\Structs\TimeOfDayDistribution $timeOfDayDistribution
     * @param string $inboundOutboundPairing
     * @param string $additionalNonStopsNumber
     * @param int $additionalNonStopsPercentage
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\Weightings $weightings = null, \Sabre\BargainFinderMax\Structs\TimeOfDayDistribution $timeOfDayDistribution = null, $inboundOutboundPairing = null, $additionalNonStopsNumber = null, $additionalNonStopsPercentage = null)
    {
        $this
            ->setWeightings($weightings)
            ->setTimeOfDayDistribution($timeOfDayDistribution)
            ->setInboundOutboundPairing($inboundOutboundPairing)
            ->setAdditionalNonStopsNumber($additionalNonStopsNumber)
            ->setAdditionalNonStopsPercentage($additionalNonStopsPercentage);
    }
    /**
     * Get Weightings value
     * @return \Sabre\BargainFinderMax\Structs\Weightings|null
     */
    public function getWeightings()
    {
        return $this->Weightings;
    }
    /**
     * Set Weightings value
     * @param \Sabre\BargainFinderMax\Structs\Weightings $weightings
     * @return \Sabre\BargainFinderMax\Structs\DiversityParameters
     */
    public function setWeightings(\Sabre\BargainFinderMax\Structs\Weightings $weightings = null)
    {
        $this->Weightings = $weightings;
        return $this;
    }
    /**
     * Get TimeOfDayDistribution value
     * @return \Sabre\BargainFinderMax\Structs\TimeOfDayDistribution|null
     */
    public function getTimeOfDayDistribution()
    {
        return $this->TimeOfDayDistribution;
    }
    /**
     * Set TimeOfDayDistribution value
     * @param \Sabre\BargainFinderMax\Structs\TimeOfDayDistribution $timeOfDayDistribution
     * @return \Sabre\BargainFinderMax\Structs\DiversityParameters
     */
    public function setTimeOfDayDistribution(\Sabre\BargainFinderMax\Structs\TimeOfDayDistribution $timeOfDayDistribution = null)
    {
        $this->TimeOfDayDistribution = $timeOfDayDistribution;
        return $this;
    }
    /**
     * Get InboundOutboundPairing value
     * @return string|null
     */
    public function getInboundOutboundPairing()
    {
        return $this->InboundOutboundPairing;
    }
    /**
     * Set InboundOutboundPairing value
     * @param string $inboundOutboundPairing
     * @return \Sabre\BargainFinderMax\Structs\DiversityParameters
     */
    public function setInboundOutboundPairing($inboundOutboundPairing = null)
    {
        $this->InboundOutboundPairing = $inboundOutboundPairing;
        return $this;
    }
    /**
     * Get AdditionalNonStopsNumber value
     * @return string|null
     */
    public function getAdditionalNonStopsNumber()
    {
        return $this->AdditionalNonStopsNumber;
    }
    /**
     * Set AdditionalNonStopsNumber value
     * @param string $additionalNonStopsNumber
     * @return \Sabre\BargainFinderMax\Structs\DiversityParameters
     */
    public function setAdditionalNonStopsNumber($additionalNonStopsNumber = null)
    {
        $this->AdditionalNonStopsNumber = $additionalNonStopsNumber;
        return $this;
    }
    /**
     * Get AdditionalNonStopsPercentage value
     * @return int|null
     */
    public function getAdditionalNonStopsPercentage()
    {
        return $this->AdditionalNonStopsPercentage;
    }
    /**
     * Set AdditionalNonStopsPercentage value
     * @param int $additionalNonStopsPercentage
     * @return \Sabre\BargainFinderMax\Structs\DiversityParameters
     */
    public function setAdditionalNonStopsPercentage($additionalNonStopsPercentage = null)
    {
        $this->AdditionalNonStopsPercentage = $additionalNonStopsPercentage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\DiversityParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
