<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiversityControlType Structs
 * Meta informations extracted from the WSDL
 * - documentation: These parameters control how IntellSell should select itineraries based not necessarily on cheapest price, but also on other criteria that guarantee a diverse response.
 * @subpackage Structs
 */
class DiversityControlType extends AbstractStructBase
{
    /**
     * The LowFareBucket
     * @var \Sabre\BargainFinderMax\Structs\LowFareBucket
     */
    public $LowFareBucket;
    /**
     * The Dimensions
     * @var \Sabre\BargainFinderMax\Structs\Dimensions
     */
    public $Dimensions;
    /**
     * Constructor method for DiversityControlType
     * @uses DiversityControlType::setLowFareBucket()
     * @uses DiversityControlType::setDimensions()
     * @param \Sabre\BargainFinderMax\Structs\LowFareBucket $lowFareBucket
     * @param \Sabre\BargainFinderMax\Structs\Dimensions $dimensions
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\LowFareBucket $lowFareBucket = null, \Sabre\BargainFinderMax\Structs\Dimensions $dimensions = null)
    {
        $this
            ->setLowFareBucket($lowFareBucket)
            ->setDimensions($dimensions);
    }
    /**
     * Get LowFareBucket value
     * @return \Sabre\BargainFinderMax\Structs\LowFareBucket|null
     */
    public function getLowFareBucket()
    {
        return $this->LowFareBucket;
    }
    /**
     * Set LowFareBucket value
     * @param \Sabre\BargainFinderMax\Structs\LowFareBucket $lowFareBucket
     * @return \Sabre\BargainFinderMax\Structs\DiversityControlType
     */
    public function setLowFareBucket(\Sabre\BargainFinderMax\Structs\LowFareBucket $lowFareBucket = null)
    {
        $this->LowFareBucket = $lowFareBucket;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \Sabre\BargainFinderMax\Structs\Dimensions|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \Sabre\BargainFinderMax\Structs\Dimensions $dimensions
     * @return \Sabre\BargainFinderMax\Structs\DiversityControlType
     */
    public function setDimensions(\Sabre\BargainFinderMax\Structs\Dimensions $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\DiversityControlType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
