<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Distribution Structs
 * Meta informations extracted from the WSDL
 * - documentation: Exactly one attribute: either Direction or Leg must be provided
 * @subpackage Structs
 */
class Distribution extends AbstractStructBase
{
    /**
     * The Range
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Range[]
     */
    public $Range;
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Direction;
    /**
     * The Leg
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Leg;
    /**
     * The Endpoint
     * Meta informations extracted from the WSDL
     * - default: Departure
     * @var string
     */
    public $Endpoint;
    /**
     * Constructor method for Distribution
     * @uses Distribution::setRange()
     * @uses Distribution::setDirection()
     * @uses Distribution::setLeg()
     * @uses Distribution::setEndpoint()
     * @param \Sabre\BargainFinderMax\Structs\Range[] $range
     * @param string $direction
     * @param int $leg
     * @param string $endpoint
     */
    public function __construct(array $range = array(), $direction = null, $leg = null, $endpoint = 'Departure')
    {
        $this
            ->setRange($range)
            ->setDirection($direction)
            ->setLeg($leg)
            ->setEndpoint($endpoint);
    }
    /**
     * Get Range value
     * @return \Sabre\BargainFinderMax\Structs\Range[]|null
     */
    public function getRange()
    {
        return $this->Range;
    }
    /**
     * Set Range value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Range[] $range
     * @return \Sabre\BargainFinderMax\Structs\Distribution
     */
    public function setRange(array $range = array())
    {
        $this->Range = $range;
        return $this;
    }
    /**
     * Add item to Range value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Range $item
     * @return \Sabre\BargainFinderMax\Structs\Distribution
     */
    public function addToRange(\Sabre\BargainFinderMax\Structs\Range $item)
    {
        $this->Range[] = $item;
        return $this;
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @uses \Sabre\BargainFinderMax\Enums\OutboundOrInbound::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\OutboundOrInbound::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \Sabre\BargainFinderMax\Structs\Distribution
     */
    public function setDirection($direction = null)
    {
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get Leg value
     * @return int|null
     */
    public function getLeg()
    {
        return $this->Leg;
    }
    /**
     * Set Leg value
     * @param int $leg
     * @return \Sabre\BargainFinderMax\Structs\Distribution
     */
    public function setLeg($leg = null)
    {
        $this->Leg = $leg;
        return $this;
    }
    /**
     * Get Endpoint value
     * @return string|null
     */
    public function getEndpoint()
    {
        return $this->Endpoint;
    }
    /**
     * Set Endpoint value
     * @uses \Sabre\BargainFinderMax\Enums\DepartureOrArrival::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\DepartureOrArrival::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endpoint
     * @return \Sabre\BargainFinderMax\Structs\Distribution
     */
    public function setEndpoint($endpoint = 'Departure')
    {
        $this->Endpoint = $endpoint;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Distribution
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
