<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DirectFlights Structs
 * Meta informations extracted from the WSDL
 * - documentation: Prefer itineraries will less connections
 * @subpackage Structs
 */
class DirectFlights extends AbstractStructBase
{
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxInclusive: 9
     * - minInclusive: 1
     * @var int
     */
    public $Priority;
    /**
     * The Leg
     * Meta informations extracted from the WSDL
     * - documentation: Which leg is most significant one? If inconclusive continue comparisons segment by segment starting from the beginning of itinerary
     * - use: optional
     * @var int
     */
    public $Leg;
    /**
     * Constructor method for DirectFlights
     * @uses DirectFlights::setPriority()
     * @uses DirectFlights::setLeg()
     * @param int $priority
     * @param int $leg
     */
    public function __construct($priority = null, $leg = null)
    {
        $this
            ->setPriority($priority)
            ->setLeg($leg);
    }
    /**
     * Get Priority value
     * @return int
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \Sabre\BargainFinderMax\Structs\DirectFlights
     */
    public function setPriority($priority = null)
    {
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get Leg value
     * @return int|null
     */
    public function getLeg()
    {
        return $this->Leg;
    }
    /**
     * Set Leg value
     * @param int $leg
     * @return \Sabre\BargainFinderMax\Structs\DirectFlights
     */
    public function setLeg($leg = null)
    {
        $this->Leg = $leg;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\DirectFlights
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
