<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dimensions Structs
 * @subpackage Structs
 */
class Dimensions extends AbstractStructBase
{
    /**
     * The TravelTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TravelTime
     */
    public $TravelTime;
    /**
     * The Carrier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Carrier
     */
    public $Carrier;
    /**
     * The OperatingDuplicate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\OperatingDuplicate
     */
    public $OperatingDuplicate;
    /**
     * The InboundOutboundPairing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\InboundOutboundPairing
     */
    public $InboundOutboundPairing;
    /**
     * The TimeOfDay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TimeOfDay
     */
    public $TimeOfDay;
    /**
     * The StopsNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\StopsNumber
     */
    public $StopsNumber;
    /**
     * The PriceWeight
     * Meta informations extracted from the WSDL
     * - default: 10
     * - maxInclusive: 10
     * - minInclusive: 0
     * @var float
     */
    public $PriceWeight;
    /**
     * Constructor method for Dimensions
     * @uses Dimensions::setTravelTime()
     * @uses Dimensions::setCarrier()
     * @uses Dimensions::setOperatingDuplicate()
     * @uses Dimensions::setInboundOutboundPairing()
     * @uses Dimensions::setTimeOfDay()
     * @uses Dimensions::setStopsNumber()
     * @uses Dimensions::setPriceWeight()
     * @param \Sabre\BargainFinderMax\Structs\TravelTime $travelTime
     * @param \Sabre\BargainFinderMax\Structs\Carrier $carrier
     * @param \Sabre\BargainFinderMax\Structs\OperatingDuplicate $operatingDuplicate
     * @param \Sabre\BargainFinderMax\Structs\InboundOutboundPairing $inboundOutboundPairing
     * @param \Sabre\BargainFinderMax\Structs\TimeOfDay $timeOfDay
     * @param \Sabre\BargainFinderMax\Structs\StopsNumber $stopsNumber
     * @param float $priceWeight
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\TravelTime $travelTime = null, \Sabre\BargainFinderMax\Structs\Carrier $carrier = null, \Sabre\BargainFinderMax\Structs\OperatingDuplicate $operatingDuplicate = null, \Sabre\BargainFinderMax\Structs\InboundOutboundPairing $inboundOutboundPairing = null, \Sabre\BargainFinderMax\Structs\TimeOfDay $timeOfDay = null, \Sabre\BargainFinderMax\Structs\StopsNumber $stopsNumber = null, $priceWeight = '10')
    {
        $this
            ->setTravelTime($travelTime)
            ->setCarrier($carrier)
            ->setOperatingDuplicate($operatingDuplicate)
            ->setInboundOutboundPairing($inboundOutboundPairing)
            ->setTimeOfDay($timeOfDay)
            ->setStopsNumber($stopsNumber)
            ->setPriceWeight($priceWeight);
    }
    /**
     * Get TravelTime value
     * @return \Sabre\BargainFinderMax\Structs\TravelTime|null
     */
    public function getTravelTime()
    {
        return $this->TravelTime;
    }
    /**
     * Set TravelTime value
     * @param \Sabre\BargainFinderMax\Structs\TravelTime $travelTime
     * @return \Sabre\BargainFinderMax\Structs\Dimensions
     */
    public function setTravelTime(\Sabre\BargainFinderMax\Structs\TravelTime $travelTime = null)
    {
        $this->TravelTime = $travelTime;
        return $this;
    }
    /**
     * Get Carrier value
     * @return \Sabre\BargainFinderMax\Structs\Carrier|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param \Sabre\BargainFinderMax\Structs\Carrier $carrier
     * @return \Sabre\BargainFinderMax\Structs\Dimensions
     */
    public function setCarrier(\Sabre\BargainFinderMax\Structs\Carrier $carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get OperatingDuplicate value
     * @return \Sabre\BargainFinderMax\Structs\OperatingDuplicate|null
     */
    public function getOperatingDuplicate()
    {
        return $this->OperatingDuplicate;
    }
    /**
     * Set OperatingDuplicate value
     * @param \Sabre\BargainFinderMax\Structs\OperatingDuplicate $operatingDuplicate
     * @return \Sabre\BargainFinderMax\Structs\Dimensions
     */
    public function setOperatingDuplicate(\Sabre\BargainFinderMax\Structs\OperatingDuplicate $operatingDuplicate = null)
    {
        $this->OperatingDuplicate = $operatingDuplicate;
        return $this;
    }
    /**
     * Get InboundOutboundPairing value
     * @return \Sabre\BargainFinderMax\Structs\InboundOutboundPairing|null
     */
    public function getInboundOutboundPairing()
    {
        return $this->InboundOutboundPairing;
    }
    /**
     * Set InboundOutboundPairing value
     * @param \Sabre\BargainFinderMax\Structs\InboundOutboundPairing $inboundOutboundPairing
     * @return \Sabre\BargainFinderMax\Structs\Dimensions
     */
    public function setInboundOutboundPairing(\Sabre\BargainFinderMax\Structs\InboundOutboundPairing $inboundOutboundPairing = null)
    {
        $this->InboundOutboundPairing = $inboundOutboundPairing;
        return $this;
    }
    /**
     * Get TimeOfDay value
     * @return \Sabre\BargainFinderMax\Structs\TimeOfDay|null
     */
    public function getTimeOfDay()
    {
        return $this->TimeOfDay;
    }
    /**
     * Set TimeOfDay value
     * @param \Sabre\BargainFinderMax\Structs\TimeOfDay $timeOfDay
     * @return \Sabre\BargainFinderMax\Structs\Dimensions
     */
    public function setTimeOfDay(\Sabre\BargainFinderMax\Structs\TimeOfDay $timeOfDay = null)
    {
        $this->TimeOfDay = $timeOfDay;
        return $this;
    }
    /**
     * Get StopsNumber value
     * @return \Sabre\BargainFinderMax\Structs\StopsNumber|null
     */
    public function getStopsNumber()
    {
        return $this->StopsNumber;
    }
    /**
     * Set StopsNumber value
     * @param \Sabre\BargainFinderMax\Structs\StopsNumber $stopsNumber
     * @return \Sabre\BargainFinderMax\Structs\Dimensions
     */
    public function setStopsNumber(\Sabre\BargainFinderMax\Structs\StopsNumber $stopsNumber = null)
    {
        $this->StopsNumber = $stopsNumber;
        return $this;
    }
    /**
     * Get PriceWeight value
     * @return float|null
     */
    public function getPriceWeight()
    {
        return $this->PriceWeight;
    }
    /**
     * Set PriceWeight value
     * @param float $priceWeight
     * @return \Sabre\BargainFinderMax\Structs\Dimensions
     */
    public function setPriceWeight($priceWeight = '10')
    {
        $this->PriceWeight = $priceWeight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Dimensions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
