<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Diagnostic Structs
 * Meta informations extracted from the WSDL
 * - documentation: Specify diagnostic code and which service to sent it to.
 * @subpackage Structs
 */
class Diagnostic extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: required
     * - pattern: [A-Za-z0-9_]+(/[A-Za-z0-9_]+)*
     * @var string
     */
    public $Code;
    /**
     * The DiagnosticArgument
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\DiagnosticArgument[]
     */
    public $DiagnosticArgument;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - documentation: This is a place holder for additional elements.
     * - minOccurs: 0
     * @var string
     */
    public $TPA_Extensions;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * Constructor method for Diagnostic
     * @uses Diagnostic::setCode()
     * @uses Diagnostic::setDiagnosticArgument()
     * @uses Diagnostic::setTPA_Extensions()
     * @uses Diagnostic::setTarget()
     * @param string $code
     * @param \Sabre\BargainFinderMax\Structs\DiagnosticArgument[] $diagnosticArgument
     * @param string $tPA_Extensions
     * @param string $target
     */
    public function __construct($code = null, array $diagnosticArgument = array(), $tPA_Extensions = null, $target = null)
    {
        $this
            ->setCode($code)
            ->setDiagnosticArgument($diagnosticArgument)
            ->setTPA_Extensions($tPA_Extensions)
            ->setTarget($target);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\Diagnostic
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get DiagnosticArgument value
     * @return \Sabre\BargainFinderMax\Structs\DiagnosticArgument[]|null
     */
    public function getDiagnosticArgument()
    {
        return $this->DiagnosticArgument;
    }
    /**
     * Set DiagnosticArgument value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\DiagnosticArgument[] $diagnosticArgument
     * @return \Sabre\BargainFinderMax\Structs\Diagnostic
     */
    public function setDiagnosticArgument(array $diagnosticArgument = array())
    {
        $this->DiagnosticArgument = $diagnosticArgument;
        return $this;
    }
    /**
     * Add item to DiagnosticArgument value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\DiagnosticArgument $item
     * @return \Sabre\BargainFinderMax\Structs\Diagnostic
     */
    public function addToDiagnosticArgument(\Sabre\BargainFinderMax\Structs\DiagnosticArgument $item)
    {
        $this->DiagnosticArgument[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return string|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param string $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\Diagnostic
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \Sabre\BargainFinderMax\Structs\Diagnostic
     */
    public function setTarget($target = null)
    {
        $this->Target = $target;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Diagnostic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
