<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Destinations Structs
 * @subpackage Structs
 */
class Destinations extends AbstractStructBase
{
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\Destination[]
     */
    public $Destination;
    /**
     * Constructor method for Destinations
     * @uses Destinations::setDestination()
     * @param \Sabre\BargainFinderMax\Structs\Destination[] $destination
     */
    public function __construct(array $destination = array())
    {
        $this
            ->setDestination($destination);
    }
    /**
     * Get Destination value
     * @return \Sabre\BargainFinderMax\Structs\Destination[]|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Destination[] $destination
     * @return \Sabre\BargainFinderMax\Structs\Destinations
     */
    public function setDestination(array $destination = array())
    {
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Add item to Destination value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Destination $item
     * @return \Sabre\BargainFinderMax\Structs\Destinations
     */
    public function addToDestination(\Sabre\BargainFinderMax\Structs\Destination $item)
    {
        $this->Destination[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Destinations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
