<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Departure Structs
 * Meta informations extracted from the WSDL
 * - documentation: Departure Information
 * @subpackage Structs
 */
class Departure extends AbstractStructBase
{
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - documentation: Departure City Code | City code type
     * - use: required
     * - length: 3
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $City;
    /**
     * The Time
     * Meta informations extracted from the WSDL
     * - documentation: Departure Time
     * - use: required
     * @var string
     */
    public $Time;
    /**
     * The Airport
     * Meta informations extracted from the WSDL
     * - documentation: Departure Airport Code | Airport code type
     * - use: required | optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * - type: UpperCaseAlphaNumericLength3to5
     * @var string
     */
    public $Airport;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - documentation: Departure State Code | State code type | The postal service standard code or abbreviation for the state, province, or region. | Used for Character Strings, length 1 to 8
     * - length: 2
     * - minLength: 2 | 1
     * - pattern: [A-Z]{2}
     * - maxLength: 8
     * @var string
     */
    public $State;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - documentation: Departure Country Code | Country code type
     * - use: optional
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $Country;
    /**
     * The Terminal
     * Meta informations extracted from the WSDL
     * - documentation: Departure Terminal
     * @var string
     */
    public $Terminal;
    /**
     * Constructor method for Departure
     * @uses Departure::setCity()
     * @uses Departure::setTime()
     * @uses Departure::setAirport()
     * @uses Departure::setState()
     * @uses Departure::setCountry()
     * @uses Departure::setTerminal()
     * @param string $city
     * @param string $time
     * @param string $airport
     * @param string $state
     * @param string $country
     * @param string $terminal
     */
    public function __construct($city = null, $time = null, $airport = null, $state = null, $country = null, $terminal = null)
    {
        $this
            ->setCity($city)
            ->setTime($time)
            ->setAirport($airport)
            ->setState($state)
            ->setCountry($country)
            ->setTerminal($terminal);
    }
    /**
     * Get City value
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Sabre\BargainFinderMax\Structs\Departure
     */
    public function setCity($city = null)
    {
        $this->City = $city;
        return $this;
    }
    /**
     * Get Time value
     * @return string
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param string $time
     * @return \Sabre\BargainFinderMax\Structs\Departure
     */
    public function setTime($time = null)
    {
        $this->Time = $time;
        return $this;
    }
    /**
     * Get Airport value
     * @return string|null
     */
    public function getAirport()
    {
        return $this->Airport;
    }
    /**
     * Set Airport value
     * @param string $airport
     * @return \Sabre\BargainFinderMax\Structs\Departure
     */
    public function setAirport($airport = null)
    {
        $this->Airport = $airport;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \Sabre\BargainFinderMax\Structs\Departure
     */
    public function setState($state = null)
    {
        $this->State = $state;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \Sabre\BargainFinderMax\Structs\Departure
     */
    public function setCountry($country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Terminal value
     * @return string|null
     */
    public function getTerminal()
    {
        return $this->Terminal;
    }
    /**
     * Set Terminal value
     * @param string $terminal
     * @return \Sabre\BargainFinderMax\Structs\Departure
     */
    public function setTerminal($terminal = null)
    {
        $this->Terminal = $terminal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Departure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
